<?php
/**
 * Admin panel view rendering.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;


function mce_panel_gen( $apivalid, $listdata, $cf7_mch, $form_tags_with_types, $mce_txcomodin ) {

	$disclosure_class = ( '1' === (string) $apivalid ) ? 'chmp-active' : 'chmp-inactive';
	?>

	<div class="mce-custom-fields <?php echo esc_attr( $disclosure_class ); ?>" id="cmatic-fields">

		<?php
		$merge_fields = isset( $cf7_mch['merge_fields'] ) ? $cf7_mch['merge_fields'] : array();

		$max_fields = CMATIC_LITE_FIELDS;

		for ( $i = 0; $i < $max_fields; $i++ ) {
			$field_index = $i + 3;
			$field_key   = 'field' . $field_index;
			$merge_field = isset( $merge_fields[ $i ] ) ? $merge_fields[ $i ] : null;

			$field_label = 'Field ' . $field_index;
			$field_type  = 'text';
			$is_required = false;
			$description = 'Map a form field to Mailchimp';

			$merge_tag = '';
			if ( $merge_field ) {
				$field_tag          = $merge_field['tag'] ?? '';
				$merge_tag          = $field_tag; // Pass to dropdown for matching.
				$field_name         = $merge_field['name'] ?? $field_tag;
				$field_type_from_mc = $merge_field['type'] ?? 'text';

				$field_label = $field_name . ' - *|' . $field_tag . '|* <span class="mce-type">' . esc_html( $field_type_from_mc ) . '</span>';

				if ( $field_tag === 'EMAIL' ) {
					$is_required = true;
					$field_type  = 'email';
					$description = 'MUST be an email tag <a href="' . esc_url( Cmatic_Pursuit::docs( 'mailchimp-required-email', 'email_field' ) ) . '" class="helping-field" target="_blank" title="get help with Subscriber Email:"> Learn More</a>';
				}
			}

			$container_style = ( $merge_field === null ) ? 'display: none;' : '';
			?>
			<div class="mcee-container" style="<?php echo esc_attr( $container_style ); ?>">
			<label for="wpcf7-mailchimp-<?php echo esc_attr( $field_key ); ?>">
				<?php echo $field_label; ?>
				<?php if ( $is_required ) : ?>
				<span class="mce-required">Required</span>
				<?php endif; ?>
			</label>
			<?php mce_render_field_dropdown( $field_key, $form_tags_with_types, $cf7_mch, $field_type, $merge_tag ); ?>

			</div>

			<?php } ?>

		<!-- Opt-in Checkbox Field -->
		<?php

		$checkbox_types = array( 'checkbox', 'acceptance' );
		$checkbox_fields = array_filter(
			$form_tags_with_types,
			function ( $field ) use ( $checkbox_types ) {
				return in_array( $field['basetype'], $checkbox_types, true );
			}
		);
		?>
		<div class="mcee-container">
			<label for="wpcf7-mailchimp-accept">
				<?php esc_html_e( 'Opt-in Checkbox', 'chimpmatic-lite' ); ?>
				<span class="mce-type"><?php esc_html_e( 'Optional', 'chimpmatic-lite' ); ?></span>
			</label>
			<select class="chm-select" id="wpcf7-mailchimp-accept" name="wpcf7-mailchimp[accept]">
				<option value=" " <?php selected( isset( $cf7_mch['accept'] ) ? $cf7_mch['accept'] : ' ', ' ' ); ?>>
					<?php esc_html_e( 'None - Always subscribe', 'chimpmatic-lite' ); ?>
				</option>
				<?php if ( empty( $checkbox_fields ) ) : ?>
					<option value="" disabled>
						<?php
						$form_title = '';
						if ( function_exists( 'wpcf7_contact_form' ) ) {
							$form_obj = wpcf7_contact_form( $mce_txcomodin );
							$form_title = $form_obj ? $form_obj->title() : '';
						}

						printf( esc_html__( '"%s" has no [checkbox] or [acceptance] fields', 'chimpmatic-lite' ), esc_html( $form_title ) );
						?>
					</option>
				<?php else : ?>
					<?php foreach ( $checkbox_fields as $field ) : ?>
						<?php
						$field_value = '[' . $field['name'] . ']';
						$saved_value = isset( $cf7_mch['accept'] ) ? $cf7_mch['accept'] : ' ';
						?>
						<option value="<?php echo esc_attr( $field_value ); ?>" <?php selected( $saved_value, $field_value ); ?>>
							<?php echo esc_html( '[' . $field['name'] . ']' ); ?> - type: <?php echo esc_html( $field['basetype'] ); ?>
						</option>
					<?php endforeach; ?>
				<?php endif; ?>
			</select>
			<small class="description">
				<?php esc_html_e( 'Only subscribe if this checkbox is checked', 'chimpmatic-lite' ); ?>
				<a href="<?php echo esc_url( Cmatic_Pursuit::docs( 'mailchimp-opt-in-checkbox', 'optin_field' ) ); ?>" class="helping-field" target="_blank" title="<?php esc_attr_e( 'Learn more about opt-in checkbox', 'chimpmatic-lite' ); ?>"><?php esc_html_e( 'Learn More', 'chimpmatic-lite' ); ?></a>
			</small>
		</div>

		<div class="mcee-container">
			<label for="wpcf7-mailchimp-double-optin">
				<?php esc_html_e( 'Double Opt-in', 'chimpmatic-lite' ); ?>
				<span class="mce-type"><?php esc_html_e( 'Optional', 'chimpmatic-lite' ); ?></span>
			</label>
			<?php $double_optin_value = mce_get_cmatic( 'double_optin', false ) ? '1' : '0'; ?>
			<select class="chm-select" id="wpcf7-mailchimp-double-optin" name="wpcf7-mailchimp[confsubs]" data-field="double_optin">
				<option value="0" <?php selected( $double_optin_value, '0' ); ?>>
					<?php esc_html_e( 'Subscribers are added immediately', 'chimpmatic-lite' ); ?>
				</option>
				<option value="1" <?php selected( $double_optin_value, '1' ); ?>>
					<?php esc_html_e( 'Subscribers must confirm via email', 'chimpmatic-lite' ); ?>
				</option>
			</select>
			<small class="description">
				<?php esc_html_e( 'Choose how subscribers are added to your Mailchimp list', 'chimpmatic-lite' ); ?>
				<a href="<?php echo esc_url( Cmatic_Pursuit::docs( 'mailchimp-double-opt-in', 'double_optin' ) ); ?>" class="helping-field" target="_blank" title="<?php esc_attr_e( 'Learn more about Double Opt-in', 'chimpmatic-lite' ); ?>"><?php esc_html_e( 'Learn More', 'chimpmatic-lite' ); ?></a>
			</small>
		</div>

	</div>

	<?php include SPARTAN_MCE_PLUGIN_DIR . 'lib/pro-features.php'; ?>
<?php } ///end mce_panel_gen() ?>


<?php

if ( class_exists( 'Cmatic_Data_Container' ) ) {
	Cmatic_Data_Container::render_open( (int) $mce_txcomodin, (string) $apivalid );
} else {
	echo '<div class="cmatic-inner">';
}
?>

	<?php

	if ( class_exists( 'Cmatic_Header' ) ) {
		$api_status = null;
		if ( isset( $apivalid ) && '1' == $apivalid ) {
			$api_status = 'connected';
		} elseif ( isset( $apivalid ) && '0' == $apivalid ) {
			$api_status = 'disconnected';
		}
		Cmatic_Header::output( array( 'api_status' => $api_status ) );
	}
	?>

	<div class="cmatic-content">

	<?php Cmatic_Api_Panel::render( $cf7_mch, (string) $apivalid ); ?>

	<?php

	if ( class_exists( 'Cmatic_Audiences' ) ) {
		Cmatic_Audiences::render( (string) $apivalid, $listdata, $cf7_mch );
	}
	?>

	<div id="chmp-new-user" class="new-user <?php echo ( ( $apivalid == 1 ) ? 'chmp-inactive' : 'chmp-active' ); ?>">
		<?php chmp_new_usr(); ?>
	</div>

	<?php

	mce_panel_gen( $apivalid, $listdata, $cf7_mch, $form_tags_with_types, $mce_txcomodin );
	?>


	<?php Cmatic_Panel_Toggles::cmatic_render(); ?>

	<?php
	if ( class_exists( 'Cmatic_Contact_Lookup' ) ) {
		Cmatic_Contact_Lookup::cmatic_render( array( 'form_id' => $mce_txcomodin ) );
	}
	?>

	<?php Cmatic_Log_Viewer::render(); ?>

	<div id="cme-container" class="mce-custom-fields vc-advanced-settings">
		<?php require SPARTAN_MCE_PLUGIN_DIR . 'lib/tanu.php'; ?>
	</div>


	<div class="vc-hidden-start dev-cta mce-cta welcome-panel">
		<div class="welcome-panel-content">
			<?php echo mce_set_welcomebanner(); ?>
		</div>
	</div>

	</div><!-- .cmatic-content -->

<?php

if ( class_exists( 'Cmatic_Data_Container' ) ) {
	Cmatic_Data_Container::render_close();
} else {
	echo '</div>';
}
?>
