<?php
/**
 * Advanced settings template.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;
?>

	<table class="form-table mt0 description">
	<tbody>

		<tr class="">
		<th scope="row">Unsubscribed</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Unsubscribed</span></legend>
			<label class="cmatic-toggle">
				<input type="checkbox" id="wpcf7-mailchimp-addunsubscr" name="wpcf7-mailchimp[addunsubscr]" data-field="unsubscribed" value="1" <?php checked( mce_get_cmatic( 'unsubscribed', false ), true ); ?> />
				<span class="cmatic-toggle-slider"></span>
			</label>
			<span class="cmatic-toggle-label"><?php echo esc_html( __( 'Marks submitted contacts as unsubscribed.', 'wpcf7' ) ); ?></span>
			<a href="<?php echo esc_url( Cmatic_Pursuit::docs( 'mailchimp-opt-in-addunsubscr', 'unsubscribed_help' ) ); ?>" class="helping-field" target="_blank" title="get help with Custom Fields"> Learn More </a>
			</fieldset>
		</td>
		</tr>




		<tr>
		<th scope="row">Debug Logger</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Debug Logger</span></legend>
			<label class="cmatic-toggle">
				<input type="checkbox" id="wpcf7-mailchimp-logfileEnabled" name="wpcf7-mailchimp[logfileEnabled]" data-field="debug" value="1" <?php checked( (bool) mce_get_cmatic( 'debug', false ), true ); ?> />
				<span class="cmatic-toggle-slider"></span>
			</label>
			<span class="cmatic-toggle-label">Enables activity logging to help troubleshoot form issues.</span>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Developer</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Developer</span></legend>
			<label class="cmatic-toggle">
				<input type="checkbox" id="wpcf7-mailchimp-cf-support" name="wpcf7-mailchimp[cf-supp]" data-field="backlink" value="1" <?php checked( mce_get_cmatic( 'backlink', false ), true ); ?> />
				<span class="cmatic-toggle-slider"></span>
			</label>
			<span class="cmatic-toggle-label">A backlink to my site, not compulsory, but appreciated</span>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Auto Update</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Auto Update</span></legend>
			<label class="cmatic-toggle">
				<input type="checkbox" id="chimpmatic-update" name="chimpmatic-update" data-field="auto_update" value="1" <?php checked( (bool) mce_get_cmatic( 'auto_update', true ), true ); ?> />
				<span class="cmatic-toggle-slider"></span>
			</label>
			<span class="cmatic-toggle-label">Auto Update Chimpmatic Lite</span>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Help Us Improve</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Help Us Improve Chimpmatic</span></legend>
			<label class="cmatic-toggle">
				<input type="checkbox" id="cmatic-telemetry-enabled" name="cmatic-telemetry-enabled" data-field="telemetry" value="1"<?php echo ( mce_get_cmatic( 'telemetry.enabled', true ) ) ? ' checked="checked"' : ''; ?> />
				<span class="cmatic-toggle-slider"></span>
			</label>
			<span class="cmatic-toggle-label">Help us improve Chimpmatic by sharing anonymous usage data</span>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">License Reset</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>License Reset</span></legend>
			<button type="button" id="cmatic-license-reset-btn" class="button">Reset License Data</button>
			<div id="cmatic-license-reset-message" style="margin-top: 10px;"></div>
			<small class="description">Clears all cached license data. Use this if you see "zombie activation" issues after deactivating your license.</small>
			</fieldset>
		</td>
		</tr>

	</tbody>
	</table>
