<?php
/**
 * PSR-4 autoloader for Metrics.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;

spl_autoload_register(
	function ( $class ) {
		$prefix   = 'Cmatic\\Metrics\\';
		$base_dir = __DIR__ . '/';
		$len      = strlen( $prefix );

		if ( strncmp( $prefix, $class, $len ) !== 0 ) {
			return;
		}

		$file = $base_dir . str_replace( '\\', '/', substr( $class, $len ) ) . '.php';

		if ( file_exists( $file ) ) {
			require $file;
		}
	}
);
