<?php
/**
 * Mailchimp API service functions.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'CMATIC_LITE_FIELDS' ) ) {
	define( 'CMATIC_LITE_FIELDS', 4 );
}

/**
 * Mask API key: first 8 chars + bullets + last 4 chars
 */
function cmatic_mask_api_key( $key ) {
	if ( empty( $key ) || strlen( $key ) < 12 ) {
		return $key;
	}
	$prefix = substr( $key, 0, 8 );
	$suffix = substr( $key, -4 );
	return $prefix . str_repeat( '•', 20 ) . $suffix;
}


function cmatic_generate_header( $token ) {
	$api_key_part = explode( '-', sanitize_text_field( $token ) )[0] ?? '';
	$user_agent   = 'ChimpMaticLite/' . SPARTAN_MCE_VERSION . '; WordPress/' . get_bloginfo( 'version' );

	return array(
		'headers'   => array(
			'Content-Type'  => 'application/json',
			'Authorization' => 'apikey ' . $api_key_part,
			'User-Agent'    => $user_agent,
		),
		'timeout'   => 20,
		'sslverify' => true,
	);
}


function cmatic_call_api_get( $token, $url ) {
	$args     = cmatic_generate_header( $token );
	$response = wp_remote_get( esc_url_raw( $url ), $args );
	if ( is_wp_error( $response ) ) {
		return array( false, $args, $response );
	}
	$body = wp_remote_retrieve_body( $response );
	return array( json_decode( $body, true ), $args, $response );
}

function cmatic_call_api_put( $token, $url, $body ) {
	$args           = cmatic_generate_header( $token );
	$args['body']   = $body;
	$args['method'] = 'PUT';
	$response       = wp_remote_request( esc_url_raw( $url ), $args );
	if ( is_wp_error( $response ) ) {
		return array( false, $response );
	}
	$body = wp_remote_retrieve_body( $response );
	return array( json_decode( $body, true ), $response );
}
