<?php
/**
 * Event handlers and scheduled tasks.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;


function cmatic_daily_disable_logging_job() {
	global $wpdb;
	// SEC-FIX: Used $wpdb->prepare() for security best practices.
	$option_names = $wpdb->get_col( $wpdb->prepare( "SELECT option_name FROM {$wpdb->options} WHERE option_name LIKE %s", 'cf7_mch_%' ) );

	foreach ( $option_names as $option_name ) {
		$config = get_option( $option_name );
		if ( is_array( $config ) && isset( $config['logfileEnabled'] ) ) {
			unset( $config['logfileEnabled'] );
			update_option( $option_name, $config );
		}
	}
}
add_action( 'cmatic_daily_cron', 'cmatic_daily_disable_logging_job' );


function cmatic_schedule_daily_cron() {
	if ( ! wp_next_scheduled( 'cmatic_daily_cron' ) ) {
		// Schedule to run once daily, at a low-traffic time.
		wp_schedule_event( strtotime( '03:00:00' ), 'daily', 'cmatic_daily_cron' );
	}
}
add_action( 'init', 'cmatic_schedule_daily_cron' );


function cmatic_clear_scheduled_events() {
	wp_clear_scheduled_hook( 'cmatic_daily_cron' );
}
register_deactivation_hook( SPARTAN_MCE_PLUGIN_FILE, 'cmatic_clear_scheduled_events' );
