<?php
/**
 * Deactivation survey initialization.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;

// Load deactivation survey class.
require_once SPARTAN_MCE_PLUGIN_DIR . 'lib/class-cmatic-deactivate.php';

// Initialize deactivation survey.
add_action(
	'init',
	function () {
		$survey = new Cmatic_Deactivation_Survey(
			array(
				'plugin_slug'     => 'contact-form-7-mailchimp-extension',
				'plugin_basename' => SPARTAN_MCE_PLUGIN_BASENAME,
				'reasons'         => array(
					array(
						'id'          => 1,
						'text'        => __( 'I found a better Mailchimp integration', 'chimpmatic-lite' ),
						'input_type'  => 'plugin-dropdown',
						'placeholder' => __( 'Select the plugin you are switching to', 'chimpmatic-lite' ),
						'max_length'  => 0,
					),
					array(
						'id'          => 2,
						'text'        => __( 'Missing features I need', 'chimpmatic-lite' ),
						'input_type'  => 'textfield',
						'placeholder' => __( 'What features would you like to see?', 'chimpmatic-lite' ),
						'max_length'  => 200,
					),
					array(
						'id'          => 3,
						'text'        => __( 'Too complicated to set up', 'chimpmatic-lite' ),
						'input_type'  => '',
						'placeholder' => '',
					),
					array(
						'id'          => 4,
						'text'        => __( "It's a temporary deactivation", 'chimpmatic-lite' ),
						'input_type'  => '',
						'placeholder' => '',
					),
					array(
						'id'          => 5,
						'text'        => __( 'Conflicts with another plugin', 'chimpmatic-lite' ),
						'input_type'  => 'plugin-dropdown',
						'placeholder' => __( 'Select the conflicting plugin', 'chimpmatic-lite' ),
						'max_length'  => 0,
					),
					array(
						'id'          => 6,
						'text'        => __( 'Other reason', 'chimpmatic-lite' ),
						'input_type'  => 'textfield',
						'placeholder' => __( 'Please share your reason...', 'chimpmatic-lite' ),
						'max_length'  => 200,
					),
				),
			)
		);

		$survey->init();
	}
);
