<?php
/**
 * Plugin action and row links.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;

class Cmatic_Plugin_Links {

	const PANEL_KEY = 'Chimpmatic';

	/** Get the settings URL for the plugin. */
	public static function get_settings_url( $form_id = null ) {
		if ( null === $form_id && function_exists( 'cmatic_newest' ) ) {
			$form_id = cmatic_newest();
		}

		if ( empty( $form_id ) ) {
			return '';
		}

		return add_query_arg(
			array(
				'page'       => 'wpcf7',
				'post'       => $form_id,
				'action'     => 'edit',
				'active-tab' => self::PANEL_KEY,
			),
			admin_url( 'admin.php' )
		);
	}

	/** Get the settings link HTML. */
	public static function get_settings_link( $form_id = null ) {
		$url = self::get_settings_url( $form_id );

		if ( empty( $url ) ) {
			return '';
		}

		return sprintf(
			'<a href="%s">%s</a>',
			esc_url( $url ),
			esc_html__( 'Settings', 'chimpmatic-lite' )
		);
	}

	public static function get_docs_link() {
		return sprintf(
			'<a href="%s" target="_blank" title="%s">%s</a>',
			esc_url( Cmatic_Pursuit::docs( '', 'plugins_page' ) ),
			esc_attr__( 'Chimpmatic Documentation', 'chimpmatic-lite' ),
			esc_html__( 'Docs', 'chimpmatic-lite' )
		);
	}

	/** Filter plugin action links to add Settings link. */
	public static function filter_action_links( array $links ) {
		$settings_link = self::get_settings_link();

		if ( ! empty( $settings_link ) ) {
			array_unshift( $links, $settings_link );
		}

		return $links;
	}

	/** Filter plugin row meta to add Documentation link. */
	public static function filter_row_meta( array $links, string $file, string $match ) {
		if ( $file === $match ) {
			$links[] = self::get_docs_link();
		}

		return $links;
	}
}
