<?php
/**
 * Plugin bootstrap.
 *
 * @package   contact-form-7-mailchimp-extension
 * @author    renzo.johnson@gmail.com
 * @copyright 2014-2026 https://renzojohnson.com
 * @license   GPL-3.0+
 */

defined( 'ABSPATH' ) || exit;


$modules = array(
	'utils/class-cmatic-utils.php',
	'class-cmatic-lite-get-fields.php',
	'class-cmatic-pursuit.php',
	'activate.php',
	'services.php',
	'enqueue.php',
	'tools.php',
	'class-cmatic-file-logger.php',
	'class-cmatic-news.php',
	'class-cmatic-header.php',
	'class-cmatic-plugin-links.php',
	'class-cmatic-api-panel.php',
	'class-cmatic-data-container.php',
	'class-cmatic-audiences.php',
	'class-cmatic-log-viewer.php',
	'class-cmatic-panel-toggles.php',
	'class-cmatic-contact-lookup.php',
	'class-cmatic-submission-feedback.php',
	'handler.php',
	'events.php',
	'rest-api.php',
	'deactivation-survey-init.php',
);

// Dynamically require each module
foreach ( $modules as $module ) {
	$path = SPARTAN_MCE_PLUGIN_DIR . '/lib/' . $module;
	if ( file_exists( $path ) ) {
		require_once $path;
	}
}

// MIGRATION: Delete this block and lib/migration.php in next version
if ( file_exists( SPARTAN_MCE_PLUGIN_DIR . '/lib/migration.php' ) ) {
	require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/migration.php';
}

// Initialize Log Viewer (portable, extensible by PRO).
Cmatic_Log_Viewer::init( 'chimpmatic-lite', '[ChimpMatic Lite]', 'chimpmatic-lite' );

// Initialize Contact Lookup (available in both Lite and Pro).
Cmatic_Contact_Lookup::init();

// Initialize Submission Feedback (injects Mailchimp response into CF7's REST response).
Cmatic_Submission_Feedback::init();

// UI Components (Modals)
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/ui/class-cmatic-modal.php';
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/ui/class-cmatic-test-submission-modal.php';

// Initialize Test Submission Modal
$test_submission_modal = new Cmatic_Test_Submission_Modal();
$test_submission_modal->init();

// Admin Bar Notification System
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/AdminBar/class-cmatic-notification.php';
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/AdminBar/class-cmatic-notification-center.php';
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/AdminBar/class-cmatic-admin-bar-menu.php';

// Initialize Admin Bar (works on both frontend and admin when logged in)
Cmatic_Notification_Center::get();
Cmatic_Admin_Bar_Menu::instance();

// Initialize Signals (Telemetry System)
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/signals/autoload.php';

Cmatic\Metrics\Bootstrap::init(
	array(
		'plugin_basename' => SPARTAN_MCE_PLUGIN_BASENAME,
		'endpoint_url'    => 'https://ping.chimpmatic.com/wp-json/chimpmatic/v1/telemetry',
	)
);
