<?php 
namespace com\zoho\crm\api\sharerecords;

use com\zoho\crm\api\util\Model;

class BodyWrapper implements Model
{

	private  $share;
	private  $notifyOnCompletion;
	private  $notify;
	private  $keyModified=array();

	/**
	 * The method to get the share
	 * @return array A array representing the share
	 */
	public function getShare()
	{
		return $this->share; 

	}

	/**
	 * The method to set the value to share
	 * @param array $share A array
	 */
	public function setShare(array $share)
	{
		$this->share=$share; 
		$this->keyModified['share'] = 1; 

	}

	/**
	 * The method to get the notifyOnCompletion
	 * @return bool A bool representing the notifyOnCompletion
	 */
	public function getNotifyOnCompletion()
	{
		return $this->notifyOnCompletion; 

	}

	/**
	 * The method to set the value to notifyOnCompletion
	 * @param bool $notifyOnCompletion A bool
	 */
	public function setNotifyOnCompletion(bool $notifyOnCompletion)
	{
		$this->notifyOnCompletion=$notifyOnCompletion; 
		$this->keyModified['notify_on_completion'] = 1; 

	}

	/**
	 * The method to get the notify
	 * @return bool A bool representing the notify
	 */
	public function getNotify()
	{
		return $this->notify; 

	}

	/**
	 * The method to set the value to notify
	 * @param bool $notify A bool
	 */
	public function setNotify(bool $notify)
	{
		$this->notify=$notify; 
		$this->keyModified['notify'] = 1; 

	}

	/**
	 * The method to check if the user has modified the given key
	 * @param string $key A string
	 * @return int A int representing the modification
	 */
	public function isKeyModified(string $key)
	{
		if(((array_key_exists($key, $this->keyModified))))
		{
			return $this->keyModified[$key]; 

		}
		return null; 

	}

	/**
	 * The method to mark the given key as modified
	 * @param string $key A string
	 * @param int $modification A int
	 */
	public function setKeyModified(string $key, int $modification)
	{
		$this->keyModified[$key] = $modification; 

	}
} 
