<?php 
namespace com\zoho\crm\api\profiles;

use com\zoho\crm\api\util\Model;

class PermissionDetail implements Model
{

	private  $id;
	private  $enabled;
	private  $name;
	private  $displayLabel;
	private  $customizable;
	private  $parentPermissions;
	private  $module;
	private  $keyModified=array();

	/**
	 * The method to get the id
	 * @return string A string representing the id
	 */
	public function getId()
	{
		return $this->id; 

	}

	/**
	 * The method to set the value to id
	 * @param string $id A string
	 */
	public function setId(string $id)
	{
		$this->id=$id; 
		$this->keyModified['id'] = 1; 

	}

	/**
	 * The method to get the enabled
	 * @return bool A bool representing the enabled
	 */
	public function getEnabled()
	{
		return $this->enabled; 

	}

	/**
	 * The method to set the value to enabled
	 * @param bool $enabled A bool
	 */
	public function setEnabled(bool $enabled)
	{
		$this->enabled=$enabled; 
		$this->keyModified['enabled'] = 1; 

	}

	/**
	 * The method to get the name
	 * @return string A string representing the name
	 */
	public function getName()
	{
		return $this->name; 

	}

	/**
	 * The method to set the value to name
	 * @param string $name A string
	 */
	public function setName(string $name)
	{
		$this->name=$name; 
		$this->keyModified['name'] = 1; 

	}

	/**
	 * The method to get the displayLabel
	 * @return string A string representing the displayLabel
	 */
	public function getDisplayLabel()
	{
		return $this->displayLabel; 

	}

	/**
	 * The method to set the value to displayLabel
	 * @param string $displayLabel A string
	 */
	public function setDisplayLabel(string $displayLabel)
	{
		$this->displayLabel=$displayLabel; 
		$this->keyModified['display_label'] = 1; 

	}

	/**
	 * The method to get the customizable
	 * @return bool A bool representing the customizable
	 */
	public function getCustomizable()
	{
		return $this->customizable; 

	}

	/**
	 * The method to set the value to customizable
	 * @param bool $customizable A bool
	 */
	public function setCustomizable(bool $customizable)
	{
		$this->customizable=$customizable; 
		$this->keyModified['customizable'] = 1; 

	}

	/**
	 * The method to get the parentPermissions
	 * @return array A array representing the parentPermissions
	 */
	public function getParentPermissions()
	{
		return $this->parentPermissions; 

	}

	/**
	 * The method to set the value to parentPermissions
	 * @param array $parentPermissions A array
	 */
	public function setParentPermissions(array $parentPermissions)
	{
		$this->parentPermissions=$parentPermissions; 
		$this->keyModified['parent_permissions'] = 1; 

	}

	/**
	 * The method to get the module
	 * @return string A string representing the module
	 */
	public function getModule()
	{
		return $this->module; 

	}

	/**
	 * The method to set the value to module
	 * @param string $module A string
	 */
	public function setModule(string $module)
	{
		$this->module=$module; 
		$this->keyModified['module'] = 1; 

	}

	/**
	 * The method to check if the user has modified the given key
	 * @param string $key A string
	 * @return int A int representing the modification
	 */
	public function isKeyModified(string $key)
	{
		if(((array_key_exists($key, $this->keyModified))))
		{
			return $this->keyModified[$key]; 

		}
		return null; 

	}

	/**
	 * The method to mark the given key as modified
	 * @param string $key A string
	 * @param int $modification A int
	 */
	public function setKeyModified(string $key, int $modification)
	{
		$this->keyModified[$key] = $modification; 

	}
} 
