<?php 
namespace com\zoho\crm\api\notifications;

use com\zoho\crm\api\util\Model;

class NotificationCondition implements Model
{

	private  $type;
	private  $module;
	private  $fieldSelection;
	private  $keyModified=array();

	/**
	 * The method to get the type
	 * @return string A string representing the type
	 */
	public function getType()
	{
		return $this->type; 

	}

	/**
	 * The method to set the value to type
	 * @param string $type A string
	 */
	public function setType(string $type)
	{
		$this->type=$type; 
		$this->keyModified['type'] = 1; 

	}

	/**
	 * The method to get the module
	 * @return Module An instance of Module
	 */
	public function getModule()
	{
		return $this->module; 

	}

	/**
	 * The method to set the value to module
	 * @param Module $module An instance of Module
	 */
	public function setModule(Module $module)
	{
		$this->module=$module; 
		$this->keyModified['module'] = 1; 

	}

	/**
	 * The method to get the fieldSelection
	 * @return Criteria An instance of Criteria
	 */
	public function getFieldSelection()
	{
		return $this->fieldSelection; 

	}

	/**
	 * The method to set the value to fieldSelection
	 * @param Criteria $fieldSelection An instance of Criteria
	 */
	public function setFieldSelection(Criteria $fieldSelection)
	{
		$this->fieldSelection=$fieldSelection; 
		$this->keyModified['field_selection'] = 1; 

	}

	/**
	 * The method to check if the user has modified the given key
	 * @param string $key A string
	 * @return int A int representing the modification
	 */
	public function isKeyModified(string $key)
	{
		if(((array_key_exists($key, $this->keyModified))))
		{
			return $this->keyModified[$key]; 

		}
		return null; 

	}

	/**
	 * The method to mark the given key as modified
	 * @param string $key A string
	 * @param int $modification A int
	 */
	public function setKeyModified(string $key, int $modification)
	{
		$this->keyModified[$key] = $modification; 

	}
} 
