<?php if (!defined('ABSPATH')) {
	exit('restricted access');
} ?>
<div class="wrap">
    <h1><?php esc_html_e('Connect CF7 to Zoho CRM Settings', 'connect-cf7-to-zoho'); ?></h1>

	<?php
	// Handling error messages passed via URL
	if (isset($_GET['cf7zh_error'])) :
		$error_code = sanitize_text_field(wp_unslash($_GET['cf7zh_error']));
		$error_message = '';
		switch ($error_code) {
			case 'empty_code':
				$error_message = __('Authorization code from Zoho is empty. Please try again.', 'connect-cf7-to-zoho');
				break;
			case 'no_settings':
				$error_message = __('Client ID or Client Secret is not configured. Please save settings first.', 'connect-cf7-to-zoho');
				break;
			case 'inv_data_center':
				$error_message = __('Invalid data center. Please check your Zoho accounts server URL.', 'connect-cf7-to-zoho');
				break;
			case 'zoho_auth_error':
				$error_message = __('An error occurred during Zoho authentication. Please check plugin logs and try again.', 'connect-cf7-to-zoho');
				break;
			default:
				$error_message = __('An unknown error occurred during authorization.', 'connect-cf7-to-zoho');
		}
		if ($error_message) :
			?>
            <div id="message" class="notice notice-error is-dismissible">
                <p><?php echo esc_html($error_message); ?></p>
            </div>
		<?php
		endif;

    elseif (isset($_POST['submit'])) :
		?>
        <div id="message" class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Settings saved successfully.', 'connect-cf7-to-zoho'); ?></p>
        </div>
	<?php endif; ?>

	<?php
	// Display special messages from the class (if any)
	// This can be useful for messages that are not a direct result of GET/POST
	if (!empty($data->settings['message'])) {
		$message_type = $data->settings['message_type'] ?? 'success';
		echo '<div class="notice notice-' . esc_attr($message_type) . ' is-dismissible"><p>' . esc_html($data->settings['message']) . '</p></div>';
	}
	?>

    <form method="post" action="">
		<?php wp_nonce_field('Cf7zh_submit_form'); // Nonce для безпеки ?>

        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <!-- Основний контент -->
                <div id="post-body-content">
                    <div class="postbox">
                        <h2 class="hndle"><span><?php esc_html_e('OAuth Settings', 'connect-cf7-to-zoho'); ?></span>
                        </h2>
                        <div class="inside">
                            <p>
								<?php esc_html_e('To connect your Contact Form 7 forms to Zoho CRM, you need to create a Zoho API client. Follow the instructions in the plugin documentation or ', 'connect-cf7-to-zoho'); ?>
                                <a href="https://accounts.zoho.com/developerconsole"
                                   target="_blank"><?php esc_html_e('Zoho\'s developer portal', 'connect-cf7-to-zoho'); ?></a>
								<?php esc_html_e(' to get your Client ID and Client Secret.', 'connect-cf7-to-zoho'); ?>
								<?php printf(
								// translators: %s is the redirect URL
									esc_html__('When creating your client, make sure to use the following Redirect URI: %s', 'connect-cf7-to-zoho'),
									'<code>' . esc_url(get_site_url() . Cf7zh_REDIRECT_URL) . '</code>'
								); ?>
                            </p>

                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row">
                                        <label for="Cf7zh_client_id"><?php esc_html_e('Client ID', 'connect-cf7-to-zoho'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text" id="Cf7zh_client_id" name="Cf7zh_client_id"
                                               class="regular-text"
                                               value="<?php echo esc_attr($data->settings['client_id'] ?? ''); ?>"
                                               required/>
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">
                                        <label for="Cf7zh_client_secret"><?php esc_html_e('Client Secret', 'connect-cf7-to-zoho'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text" id="Cf7zh_client_secret" name="Cf7zh_client_secret"
                                               class="regular-text"
                                               value="<?php echo esc_attr($data->settings['client_secret'] ?? ''); ?>"
                                               required/>
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">
                                        <label for="Cf7zh_current_user_email"><?php esc_html_e('Zoho Account Email', 'connect-cf7-to-zoho'); ?></label>
                                    </th>
                                    <td>
                                        <input type="email" id="Cf7zh_current_user_email"
                                               name="Cf7zh_current_user_email" class="regular-text"
                                               value="<?php echo esc_attr($data->settings['current_user_email'] ?? ''); ?>"
                                               required/>
                                        <p class="description"><?php esc_html_e('The primary email address of the Zoho account you are connecting.', 'connect-cf7-to-zoho'); ?></p>
                                    </td>
                                </tr>
                            </table>
							<?php if (!empty($data->settings['client_id']) && !empty($data->settings['client_secret'])) : ?>
                                <p>
                                    <a class="button button-secondary"
                                       href="<?php echo esc_url($data->settings['zoho_auth_url']); ?>"
                                       target="_self">
                                        <span class="dashicons dashicons-update"
                                              style="vertical-align: middle; margin-top: -2px;"></span> <?php esc_html_e('Authorize with Zoho CRM', 'connect-cf7-to-zoho'); ?>
                                    </a>
                                </p>
                                <p class="description">
									<?php esc_html_e('Click this button to grant access to Zoho CRM. You will be redirected to Zoho to authenticate.', 'connect-cf7-to-zoho'); ?>
                                </p>
							<?php else : ?>
                                <p class="description">
									<?php esc_html_e('Please enter and save your Client ID and Client Secret to enable Zoho CRM authorization.', 'connect-cf7-to-zoho'); ?>
                                </p>
							<?php endif; ?>
                        </div>
                    </div>

                    <div class="postbox">
                        <h2 class="hndle">
                            <span><?php esc_html_e('API Error Notification', 'connect-cf7-to-zoho'); ?></span></h2>
                        <div class="inside">
                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row">
                                        <label for="Cf7zh_notification_subject"><?php esc_html_e('Subject', 'connect-cf7-to-zoho'); ?></label>
                                    </th>
                                    <td>
                                        <input class="regular-text" type="text" id="Cf7zh_notification_subject"
                                               name="Cf7zh_notification_subject"
                                               value="<?php echo esc_attr($data->settings['notification_subject'] ?? ''); ?>"/>
                                        <p class="description"><?php esc_html_e('Enter the subject for API error notification emails.', 'connect-cf7-to-zoho'); ?></p>
                                    </td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row">
                                        <label for="Cf7zh_notification_send_to"><?php esc_html_e('Send To', 'connect-cf7-to-zoho'); ?></label>
                                    </th>
                                    <td>
                                        <input class="regular-text" type="text" id="Cf7zh_notification_send_to"
                                               name="Cf7zh_notification_send_to"
                                               value="<?php echo esc_attr($data->settings['notification_send_to'] ?? ''); ?>"
                                               placeholder="<?php esc_attr_e('e.g., admin@example.com, support@example.com', 'connect-cf7-to-zoho'); ?>"/>
                                        <p class="description"><?php esc_html_e('Enter the email address. For multiple email addresses, separate them with commas.', 'connect-cf7-to-zoho'); ?></p>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="postbox">
                        <h2 class="hndle"><span><?php esc_html_e('Uninstall Settings', 'connect-cf7-to-zoho'); ?></span>
                        </h2>
                        <div class="inside">
                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row"><?php esc_html_e('Data Deletion', 'connect-cf7-to-zoho'); ?></th>
                                    <td>
                                        <fieldset>
                                            <legend class="screen-reader-text">
                                                <span><?php esc_html_e('Delete data on uninstall?', 'connect-cf7-to-zoho'); ?></span>
                                            </legend>
                                            <label for="Cf7zh_uninstall">
                                                <input type="checkbox" name="Cf7zh_uninstall" id="Cf7zh_uninstall"
                                                       value="1" <?php checked($data->settings['uninstall'], '1'); ?> />
												<?php esc_html_e('Check this box to remove all plugin data (including OAuth tokens and settings) when uninstalling the plugin.', 'connect-cf7-to-zoho'); ?>
                                            </label>
                                            <p class="description"><?php esc_html_e('Warning: This action cannot be undone.', 'connect-cf7-to-zoho'); ?></p>
                                        </fieldset>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div> <!-- /post-body-content -->

                <!-- Sidebar -->
                <div id="postbox-container-1" class="postbox-container">
                    <div class="postbox">
                        <h2 class="hndle"><span><?php esc_html_e('Save Settings', 'connect-cf7-to-zoho'); ?></span></h2>
                        <div class="inside">
							<?php submit_button(esc_html__('Save Changes', 'connect-cf7-to-zoho'), 'primary', 'submit', true); ?>

                        </div>
                    </div>
					<?php
					// Add token availability check and expiry time display
					global $wpdb;
					$token_store = new \Procoders\Cf7zh\Admin\WpdbTokenStore($wpdb->prefix . \Cf7zh_TOKEN_TABLE);
					$stored_token = $token_store->getTokenByEmail(get_option('Cf7zh_current_user_email'));

					if ($stored_token && $stored_token->getRefreshToken()) {
						?>
                        <div class="postbox">
                            <h2 class="hndle">
                                <span><?php esc_html_e('Current Token Status', 'connect-cf7-to-zoho'); ?></span></h2>
                            <div class="inside">
                                <p style="color: green; display: flex; align-items: center;"><span
                                            class="dashicons dashicons-yes-alt"
                                            style="margin-right: 5px;"></span> <?php esc_html_e('Refresh token found in the database.', 'connect-cf7-to-zoho'); ?>
                                </p>
								<?php
								$expiry_time = $stored_token->getExpiresIn();
								if (!empty($expiry_time)) {
									$expiry_datetime = new DateTime("@" . $expiry_time);
									$formatted_expiry = $expiry_datetime->format('Y-m-d H:i:s');

									echo '<p><strong>' . esc_html__('Token expires in:', 'connect-cf7-to-zoho') . '</strong> ' . esc_html($formatted_expiry) . '</p>';
								} else {
									echo '<p><strong>' . esc_html__('Token expiry time:', 'connect-cf7-to-zoho') . '</strong> ' . esc_html__('Information not available.', 'connect-cf7-to-zoho') . '</p>';
								}
								?>
                            </div>
                        </div>
						<?php
					} elseif (get_option('Cf7zh_client_id')) {
						// Якщо є ID клієнта, але токен не знайдено
						?>
                        <div class="postbox">
                            <h2 class="hndle">
                                <span><?php esc_html_e('Current Token Status', 'connect-cf7-to-zoho'); ?></span></h2>
                            <div class="inside">
                                <p style="color: orange; display: flex; align-items: center;"><span
                                            class="dashicons dashicons-warning"
                                            style="margin-right: 5px;"></span> <?php esc_html_e('No refresh token found in the database. Please authorize with Zoho CRM.', 'connect-cf7-to-zoho'); ?>
                                </p>
                            </div>
                        </div>
						<?php
					}
					?>
                </div><!-- /postbox-container-1 -->
            </div><!-- /post-body -->
            <br class="clear">
        </div><!-- /poststuff -->
    </form>
</div><!-- /wrap -->