<?php
/**
 * Helper functions for the plugin.
 *
 * @package Cf7zh
 */

namespace Procoders\Cf7zh;

use Procoders\Cf7zh\Loader as Loader;

/**
 * Class Functions
 */
class Functions
{
	
	/**
	 * Return the plugin slug.
	 *
	 * @return string plugin slug.6
	 */
	public static function get_plugin_slug(): string
	{
		return dirname(plugin_basename(Cf7zh_FILE));
	}

	/**
	 * Return the basefile for the plugin.
	 *
	 * @return string base file for the plugin.
	 */
	public static function get_plugin_file(): string
	{
		return plugin_basename(Cf7zh_FILE);
	}

	/**
	 * Return the plugin path.
	 *
	 * @return string path to plugin
	 */
	public static function get_plugin_path(): string
	{
		return plugin_dir_path(__FILE__);
	}

	/**
	 * Return the logs directory path in the uploads folder.
	 *
	 * @return string path to logs directory
	 */
	public static function get_logs_path(): string
	{
		$upload_dir = wp_upload_dir();
		$logs_dir = $upload_dir['basedir'] . '/cf7-to-zoho-logs';

		// Create directory if it doesn't exist
		if (!file_exists($logs_dir)) {
			wp_mkdir_p($logs_dir);
		}

		return trailingslashit($logs_dir);
	}

	/**
	 * Return the version for the plugin.
	 *
	 * @return float version for the plugin.
	 */
	public static function get_plugin_version(): float
	{
		return Cf7zh_VERSION;
	}

	/**
	 * Return the license server
	 *
	 * @return string lisense server url
	 */
	public static function get_license_server(): string
	{
		return Cf7zh_LSERVER;
	}

	public static function return_error(string $message): void
	{
		$template = new loader();
		$template->set_template_data(
			[
				'template' => $template,
				'message' => [
					'success' => false,
					'text' => $message,
				]
			]
		)->get_template_part('admin/message');
		die();
	}
}
