<?php
/**
 * Initialize and display admin logs page
 *
 * @package Cf7zh
 */

namespace Procoders\Cf7zh\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'restricted access' );
}

use Procoders\Cf7zh\Functions as Functions;
use Procoders\Cf7zh\Loader as Loader;

/**
 * Class Functions
 */
class Logs {

	/**
	 * This function handles logging of errors. It uses a file located by life_path as a storage medium for errors.
	 * The function opens the file, reads its content and then closes it.
	 *
	 * @return void
	 */
	public static function error_logs_callback(): void {
		require_once ABSPATH . 'wp-admin/includes/file.php';
		WP_Filesystem();
		global $wp_filesystem;

		$template  = new Loader();
		$file_path = Functions::get_logs_path() . 'debug.log';

		$file_data = $wp_filesystem->get_contents( $file_path );
		if ( false === $file_data ) {
			$file_data = esc_html__( 'No Error Logs found.', 'connect-cf7-to-zoho' );
		}
		$template->set_template_data(
			array(
				'template'  => $template,
				'file_data' => $file_data,
			)
		)->get_template_part( 'admin/logs' );
	}

	/**
	 * Method to handle error response.
	 *
	 * @param object $response The response object.
	 * @param int|null $form_id The ID of the form (optional).
	 *
	 * @return void
	 */
	public static function handleErrorResponse( string $message, ?int $form_id = null ): bool {
		global $wp_filesystem;

		// Include the WP_Filesystem class.
		require_once( ABSPATH . 'wp-admin/includes/file.php' );

		// Initialize the WP_Filesystem.
		WP_Filesystem();

		// Define file permissions if not defined
		if (!defined('FS_CHMOD_FILE')) {
			define('FS_CHMOD_FILE', 0644);
		}

		// Get logs directory from the uploads folder
		$log_path = Functions::get_logs_path();
		$log_file = $log_path . 'debug.log';

		// Create log file if it doesn't exist
		if ( ! $wp_filesystem->exists( $log_file ) ) {
			$wp_filesystem->put_contents( $log_file, '', FS_CHMOD_FILE ); // empty file
		}

		$log     = $wp_filesystem->get_contents( $log_file );
		$log     .= 'Message: ' . $message . "\n";
		$send_to = get_option( 'cfhs_notification_send_to' );
		$log     .= 'Date: ' . gmdate( 'Y-m-d H:i:s' ) . "\n\n";
		$log     .= 'Form id: ' . $form_id ?? 'Not set' . "\n\n";

		if ( $send_to ) {
			$to      = $send_to;
			$subject = get_option( 'cfhs_notification_subject' );
			$body    = '<ul style="list-style:none;padding-left:0; margin-left:0;" >';
			$body    .= '<li><strong>Form ID:</strong> ' . $form_id ?? 'Not set' . '</li>';
			$body    .= '<li><strong>Message:</strong> ' . $message . '</li>';
			$body    .= '<li><strong>Date:</strong> ' . gmdate( 'Y-m-d H:i:s' ) . '</li>';
			$body    .= '</ul>';

			$headers = array(
				'Content-Type: text/html; charset=UTF-8',
			);

			wp_mail( $to, $subject, $body, $headers );
		}
		$wp_filesystem->put_contents( $log_file, $log, FS_CHMOD_FILE );

		// Log to WordPress error log as well for better integration with WordPress
		error_log('CF7 to Zoho: ' . $message);

		return true;

	}
}
