<?php
/**
 * Plugin Name:       Connect Contact Form 7 to Zoho
 * Plugin URI:        https://wordpress.org/plugins/connect-cf7-to-zoho/
 * Description:       Seamlessly integrate Contact Form 7 with Zoho to automate your lead management process.
 * Version:           1.0.3
 * Requires at least: 6.2
 * Requires PHP:      8.0
 * Requires Plugins: contact-form-7
 * Author:            ProCoders
 * Author URI:        https://procoders.tech/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       connect-cf7-to-zoho
 * Domain Path:       /languages
 *
 * @package Cf7zh
 */

namespace Procoders\Cf7zh;

use \Procoders\Cf7zh\Admin\RegisterMenu as Menu;
use \Procoders\Cf7zh\Admin\SettingsLinks as Links;
use \Procoders\Cf7zh\Admin\ScriptsManager as Scripts;

define( 'Cf7zh_VERSION', '1.0.0' );
define( 'Cf7zh_FILE', __FILE__ );
define( 'Cf7zh_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'Cf7zh_TOKEN_TABLE', "cf7zh_oauth_tokens" );
define( 'Cf7zh_REDIRECT_URL', "/wp-json/wp/v2/cf7zh/auth" );
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) {
	require_once __DIR__ . '/vendor/autoload.php';
}

/**
 * Cf7zh class.
 */
class Cf7zh {

	/**
	 * Holds the class instance.
	 *
	 * @var Cf7zh $instance
	 */
	private static ?Cf7zh $instance = null;

	/**
	 * Return an instance of the class
	 *
	 * @return Cf7zh class instance.
	 * @since 1.0.0
	 */
	public static function get_instance(): Cf7zh {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	/**
	 * Class initializer.
	 */
	public function plugins_loaded(): void {

		// Register the admin menu.
		Menu::run();
		Links::run();
		// Register Script.
		Scripts::run();
		$submission = new Includes\Submission();

		$init = new \Procoders\Cf7zh\Admin\Init();

		add_action( 'init', [ $this, 'init' ] );
		add_action( 'wpcf7_before_send_mail', [ $submission, 'init' ], 10, 3 );
		add_action( 'rest_api_init', [ $init, 'set_route' ] );

	}

	/**
	 * Init plugin.
	 */
	public function init(): void {
		// Silent.
	}

}

add_action(
	'plugins_loaded',
	function () {
		$Cf7zh = Cf7zh::get_instance();
		$Cf7zh->plugins_loaded();
	}
);

function create_oAuthToken_table(): void {
	global $wpdb;
	$table_name      = $wpdb->prefix . Cf7zh_TOKEN_TABLE;
	$charset_collate = $wpdb->get_charset_collate();

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

	$sql = "CREATE TABLE {$table_name} (
        id VARCHAR(100) NOT NULL,
        user_name VARCHAR(255) NOT NULL,
        client_id VARCHAR(255) NOT NULL,
        client_secret VARCHAR(255) NOT NULL,
        refresh_token VARCHAR(255) NOT NULL,
        access_token VARCHAR(255) NOT NULL,
        grant_token VARCHAR(255),
        expiry_time VARCHAR(20),
        redirect_url VARCHAR(255),
        api_domain VARCHAR(255),
        PRIMARY KEY (id)
    ) {$charset_collate};";

	dbDelta( $sql );
}

register_activation_hook( __FILE__, 'Procoders\Cf7zh\create_oAuthToken_table' );
