<?php
/**
 * ConfigiView Template
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$colors = get_option(ConfigiView::OPTION_COLORS, ConfigiView::get_default_colors());
$patterns = get_option(ConfigiView::OPTION_PATTERNS, ConfigiView::get_default_patterns());
if (!is_array($colors)) {
    $colors = array();
}
if (!is_array($patterns)) {
    $patterns = array();
}
$extra_groups = get_option(ConfigiView::OPTION_EXTRA_GROUPS, array());
$is_pro_active = ConfigiView::is_pro_active();
$base_group_visibility = ConfigiView::get_base_group_visibility();
$show_group_one = !$is_pro_active || !isset($base_group_visibility['group_1']) || (int) $base_group_visibility['group_1'] === 1;
$show_group_two = !$is_pro_active || !isset($base_group_visibility['group_2']) || (int) $base_group_visibility['group_2'] === 1;
if (!is_array($extra_groups) || !$is_pro_active) {
    $extra_groups = array();
}
$labels = get_option(ConfigiView::OPTION_LABELS, ConfigiView::get_default_labels());
$cta_settings = ConfigiView::get_cta_settings();
$cta_mode = ('shortcode' === (string) $cta_settings['mode'] && $is_pro_active) ? 'shortcode' : 'mailto';
$cta_button_label = isset($cta_settings['button_label']) && '' !== trim((string) $cta_settings['button_label'])
    ? (string) $cta_settings['button_label']
    : ConfigiView::get_default_cta_button_label();
$cta_subject_template = isset($cta_settings['subject_template']) && '' !== trim((string) $cta_settings['subject_template'])
    ? (string) $cta_settings['subject_template']
    : ConfigiView::get_default_cta_subject();
$cta_body_template = isset($cta_settings['body_template']) && '' !== trim((string) $cta_settings['body_template'])
    ? (string) $cta_settings['body_template']
    : ConfigiView::get_default_cta_body();
$cta_shortcode = isset($cta_settings['shortcode']) ? sanitize_text_field((string) $cta_settings['shortcode']) : '';
$cta_email = sanitize_email((string) get_option(ConfigiView::OPTION_EMAIL, ''));
if ('' === $cta_email) {
    $cta_email = sanitize_email((string) get_option('admin_email'));
}
$initial_color = __('Not selected', 'configiview');
$initial_pattern = __('Not selected', 'configiview');
$initial_subject = strtr(
    $cta_subject_template,
    array(
        '{color}' => $initial_color,
        '{pattern}' => $initial_pattern,
        '{group1}' => $initial_color,
        '{group2}' => $initial_pattern,
    )
);
$initial_body = strtr(
    $cta_body_template,
    array(
        '{color}' => $initial_color,
        '{pattern}' => $initial_pattern,
        '{group1}' => $initial_color,
        '{group2}' => $initial_pattern,
    )
);
$initial_mailto = 'mailto:' . $cta_email . '?subject=' . rawurlencode($initial_subject) . '&body=' . rawurlencode($initial_body);

if (empty($colors)) {
    $colors = ConfigiView::get_default_colors();
}

if (empty($patterns)) {
    $patterns = ConfigiView::get_default_patterns();
}

$group_one_singular = isset($labels['group_one_singular']) && $labels['group_one_singular'] !== '' ? $labels['group_one_singular'] : __('Color', 'configiview');
$group_one_plural = isset($labels['group_one_plural']) && $labels['group_one_plural'] !== '' ? $labels['group_one_plural'] : __('Colors', 'configiview');
$group_two_singular = isset($labels['group_two_singular']) && $labels['group_two_singular'] !== '' ? $labels['group_two_singular'] : __('Pattern', 'configiview');
$group_two_plural = isset($labels['group_two_plural']) && $labels['group_two_plural'] !== '' ? $labels['group_two_plural'] : __('Patterns', 'configiview');
$show_cta = !isset($atts['show_cta']) || $atts['show_cta'] !== 'no';
if (!is_array($extra_groups)) {
    $extra_groups = array();
}
$option_groups_meta = array();
if ($show_group_one) {
    $option_groups_meta[] = array('index' => 0, 'singular' => $group_one_singular, 'plural' => $group_one_plural);
}
if ($show_group_two) {
    $option_groups_meta[] = array('index' => 1, 'singular' => $group_two_singular, 'plural' => $group_two_plural);
}
foreach ($extra_groups as $g_index => $group) {
    /* translators: %d: Option group number. */
    $singular = isset($group['singular']) && '' !== trim((string) $group['singular']) ? (string) $group['singular'] : sprintf(__('Group %d', 'configiview'), (int) $g_index + 3);
    $plural = isset($group['plural']) && '' !== trim((string) $group['plural']) ? (string) $group['plural'] : $singular;
    $option_groups_meta[] = array(
        'index' => (int) $g_index + 2,
        'singular' => $singular,
        'plural' => $plural,
    );
}

$combo_previews = get_option(ConfigiView::OPTION_COMBO_PREVIEWS, ConfigiView::get_default_combo_previews());
if (empty($combo_previews)) {
    $combo_previews = ConfigiView::get_default_combo_previews();
}
if (!is_array($combo_previews)) {
    $combo_previews = array();
}
$combo_visibility = array();
if ($is_pro_active) {
    $saved_combo_visibility = get_option(ConfigiView::OPTION_COMBO_VISIBILITY, array());
    if (is_array($saved_combo_visibility)) {
        $combo_visibility = $saved_combo_visibility;
    }
}
$frontend_settings = ConfigiView::get_frontend_settings();
$accordion_enabled = $is_pro_active
    && count($option_groups_meta) > 2
    && isset($frontend_settings['accordion_enabled'])
    && (int) $frontend_settings['accordion_enabled'] === 1;
?>

<div class="configiview configiview-visualizer<?php echo $accordion_enabled ? ' configiview-has-accordion' : ''; ?>" data-accordion-enabled="<?php echo $accordion_enabled ? '1' : '0'; ?>">
    <div class="configiview-top">
        <div
            class="configiview-preview"
            data-combo-previews="<?php echo esc_attr(wp_json_encode($combo_previews)); ?>"
            data-combo-visibility="<?php echo esc_attr(wp_json_encode($combo_visibility)); ?>"
            data-option-groups="<?php echo esc_attr(wp_json_encode($option_groups_meta)); ?>"
        >
            <div class="configiview-preview-empty-note"></div>
        </div>

        <div class="configiview-sidebar">
            <?php if ($show_group_one): ?>
            <div class="configiview-section configiview-sidebar-section<?php echo $accordion_enabled ? ' configiview-accordion-section' : ''; ?>" data-group-index="0">
                <button type="button" class="configiview-sidebar-title" data-group-index="0" <?php echo $accordion_enabled ? 'aria-controls="configiviewGroupPanel0" aria-expanded="true"' : ''; ?>><?php echo esc_html($group_one_plural); ?></button>
                <div class="configiview-accordion-panel" id="configiviewGroupPanel0">
                <div class="configiview-grid configiview-grid-sidebar">
                    <?php foreach ($colors as $color): ?>
                        <?php
                        $color_name = isset($color['name']) ? (string) $color['name'] : '';
                        $color_image = isset($color['image']) ? (string) $color['image'] : '';
                        ?>
                        <?php if ('' !== $color_name && '' !== $color_image): ?>
                            <?php
                            $color_preview = isset($color['preview']) && '' !== (string) $color['preview'] ? (string) $color['preview'] : $color_image;
                            $color_key = isset($color['key']) ? ConfigiView::normalize_choice_key($color['key']) : ConfigiView::normalize_choice_key($color_name);
                            ?>
                            <div
                                class="configiview-item configiview-option-item configiview-color-item"
                                data-group-index="0"
                                data-name="<?php echo esc_attr($color_name); ?>"
                                data-key="<?php echo esc_attr($color_key); ?>"
                                data-preview="<?php echo esc_url($color_preview); ?>"
                            >
                                <img src="<?php echo esc_url($color_image); ?>" alt="<?php echo esc_attr($color_name); ?>" loading="lazy">
                                <div class="configiview-label"><?php echo esc_html($color_name); ?></div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if ($show_group_two): ?>
            <div class="configiview-section configiview-sidebar-section<?php echo $accordion_enabled ? ' configiview-accordion-section' : ''; ?>" data-group-index="1">
                <button type="button" class="configiview-sidebar-title" data-group-index="1" <?php echo $accordion_enabled ? 'aria-controls="configiviewGroupPanel1" aria-expanded="false"' : ''; ?>><?php echo esc_html($group_two_plural); ?></button>
                <div class="configiview-accordion-panel" id="configiviewGroupPanel1">
                <div class="configiview-grid configiview-grid-sidebar">
                    <?php foreach ($patterns as $pattern): ?>
                        <?php
                        $pattern_name = isset($pattern['name']) ? (string) $pattern['name'] : '';
                        $pattern_image = isset($pattern['image']) ? (string) $pattern['image'] : '';
                        ?>
                        <?php if ('' !== $pattern_name && '' !== $pattern_image): ?>
                            <?php
                            $pattern_preview = isset($pattern['preview']) && '' !== (string) $pattern['preview'] ? (string) $pattern['preview'] : $pattern_image;
                            $pattern_key = isset($pattern['key']) ? ConfigiView::normalize_choice_key($pattern['key']) : ConfigiView::normalize_choice_key($pattern_name);
                            ?>
                            <div
                                class="configiview-item configiview-option-item configiview-pattern-item"
                                data-group-index="1"
                                data-name="<?php echo esc_attr($pattern_name); ?>"
                                data-key="<?php echo esc_attr($pattern_key); ?>"
                                data-preview="<?php echo esc_url($pattern_preview); ?>"
                            >
                                <img src="<?php echo esc_url($pattern_image); ?>" alt="<?php echo esc_attr($pattern_name); ?>" loading="lazy">
                                <div class="configiview-label"><?php echo esc_html($pattern_name); ?></div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <?php endif; ?>

            <?php foreach ($extra_groups as $g_index => $group): ?>
                <?php
                $g_items = isset($group['items']) && is_array($group['items']) ? $group['items'] : array();
                /* translators: %d: Option group number. */
                $g_plural = isset($group['plural']) && '' !== trim((string) $group['plural']) ? (string) $group['plural'] : sprintf(__('Group %d', 'configiview'), (int) $g_index + 3);
                $group_display_index = (int) $g_index + 2;
                ?>
                <div class="configiview-section configiview-sidebar-section<?php echo $accordion_enabled ? ' configiview-accordion-section' : ''; ?>" data-group-index="<?php echo esc_attr((string) $group_display_index); ?>">
                    <button type="button" class="configiview-sidebar-title" data-group-index="<?php echo esc_attr((string) $group_display_index); ?>" <?php echo $accordion_enabled ? 'aria-controls="configiviewGroupPanel' . esc_attr((string) $group_display_index) . '" aria-expanded="false"' : ''; ?>><?php echo esc_html($g_plural); ?></button>
                    <div class="configiview-accordion-panel" id="configiviewGroupPanel<?php echo esc_attr((string) $group_display_index); ?>">
                    <div class="configiview-grid configiview-grid-sidebar">
                        <?php foreach ($g_items as $item): ?>
                            <?php
                            $item_name = isset($item['name']) ? (string) $item['name'] : '';
                            $item_image = isset($item['image']) ? (string) $item['image'] : '';
                            ?>
                            <?php if ('' !== $item_name && '' !== $item_image): ?>
                                <?php
                                $item_preview = isset($item['preview']) && '' !== (string) $item['preview'] ? (string) $item['preview'] : $item_image;
                                $item_key = isset($item['key']) ? ConfigiView::normalize_choice_key($item['key']) : ConfigiView::normalize_choice_key($item_name);
                                ?>
                                <div
                                    class="configiview-item configiview-option-item"
                                    data-group-index="<?php echo esc_attr((string) $group_display_index); ?>"
                                    data-name="<?php echo esc_attr($item_name); ?>"
                                    data-key="<?php echo esc_attr($item_key); ?>"
                                    data-preview="<?php echo esc_url($item_preview); ?>"
                                >
                                    <img src="<?php echo esc_url($item_image); ?>" alt="<?php echo esc_attr($item_name); ?>" loading="lazy">
                                    <div class="configiview-label"><?php echo esc_html($item_name); ?></div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if ($show_cta): ?>
        <div class="configiview-selection-bar">
            <div class="configiview-selection-items">
                <?php if ($show_group_one): ?>
                <div class="configiview-selection-item">
                    <strong><?php echo esc_html($group_one_singular); ?>:</strong>
                    <span id="configiviewSelectedColor"><?php esc_html_e('Not selected', 'configiview'); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($show_group_two): ?>
                <div class="configiview-selection-item">
                    <strong><?php echo esc_html($group_two_singular); ?>:</strong>
                    <span id="configiviewSelectedPattern"><?php esc_html_e('Not selected', 'configiview'); ?></span>
                </div>
                <?php endif; ?>
                <?php foreach ($extra_groups as $g_index => $group): ?>
                    <?php
                    /* translators: %d: Option group number. */
                    $g_singular = isset($group['singular']) && '' !== trim((string) $group['singular']) ? (string) $group['singular'] : sprintf(__('Group %d', 'configiview'), (int) $g_index + 3);
                    $selection_index = (int) $g_index + 2;
                    ?>
                    <div class="configiview-selection-item">
                        <strong><?php echo esc_html($g_singular); ?>:</strong>
                        <span id="configiviewSelectedGroup<?php echo esc_attr((string) $selection_index); ?>"><?php esc_html_e('Not selected', 'configiview'); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php if ('shortcode' === $cta_mode && '' !== $cta_shortcode): ?>
                <a
                    class="configiview-quick-inquiry configiview-quick-inquiry-toggle"
                    id="configiviewQuickInquiry"
                    href="#configiviewQuickInquiryForm"
                ><?php echo esc_html($cta_button_label); ?></a>
                <div class="configiview-quick-inquiry-form" id="configiviewQuickInquiryForm" style="display:none;"><?php echo do_shortcode($cta_shortcode); ?></div>
            <?php else: ?>
                <a
                    class="configiview-quick-inquiry"
                    id="configiviewQuickInquiry"
                    href="<?php echo esc_url($initial_mailto); ?>"
                ><?php echo esc_html($cta_button_label); ?></a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
