(function($) {
    'use strict';

    $(document).ready(function() {
        var i18n = (typeof configiViewSettingsPage !== 'undefined') ? configiViewSettingsPage : {};
        var optionExtraGroupsKey = (i18n.optionExtraGroupsKey || 'configiview_extra_groups').toString();
        var submitVisibleTabs = Array.isArray(i18n.submitVisibleTabs) ? i18n.submitVisibleTabs : ['colors-patterns', 'combo-previews', 'settings'];
        var isProActive = parseInt(i18n.isProActive, 10) === 1;

        function t(key, fallback) {
            var value = i18n[key];
            return (typeof value === 'string' && value !== '') ? value : fallback;
        }

        function shouldShowSubmitForTarget(target) {
            var normalized = (target || '').toString().replace('#', '');
            return submitVisibleTabs.indexOf(normalized) !== -1;
        }

        function toggleSubmitForTarget(target) {
            var $submitWrap = $('#configiview-submit-wrap');
            if (!$submitWrap.length) {
                return;
            }
            if (shouldShowSubmitForTarget(target)) {
                $submitWrap.show();
            } else {
                $submitWrap.hide();
            }
        }

        function activateTabByTarget(target) {
            if (!target) {
                return;
            }
            var $tab = $('.nav-tab[href="' + target + '"]');
            if (!$tab.length) {
                return;
            }
            $('.nav-tab').removeClass('nav-tab-active');
            $tab.addClass('nav-tab-active');
            $('.floor-viz-tab-content').hide();
            $(target).show();
            var tabName = target.replace('#', '');
            var referer = 'admin.php?page=configiview-settings&tab=' + encodeURIComponent(tabName);
            $('input[name="_wp_http_referer"]').val(referer);
            toggleSubmitForTarget(target);
        }

        function applyUploadIcons() {
            $('.floor-viz-upload-btn').each(function() {
                if ($(this).find('.dashicons').length === 0) {
                    $(this).prepend('<span class="dashicons dashicons-upload" aria-hidden="true"></span>');
                }
            });
        }

        function reindexExtraGroups() {
            $('#configiview-extra-groups .configiview-group-card').each(function(groupIndex) {
                var $group = $(this);
                $group.attr('data-group-index', groupIndex);
                var singularValue = ($group.find('.configiview-group-singular').val() || '').toString().trim();
                var pluralValue = ($group.find('.configiview-group-plural').val() || '').toString().trim();
                var headingText = pluralValue || (t('groupLabel', 'Group') + ' ' + (groupIndex + 3));
                $group.find('.configiview-group-title').text(headingText);
                var addLabelBase = singularValue || t('optionLabel', 'Option');
                $group.find('.configiview-add-extra-item').text(t('addLabel', 'Add') + ' ' + addLabelBase);
                $group.find('.configiview-option-name-header').text(addLabelBase + ' ' + t('nameLabel', 'Name'));

                $group.find('input, textarea, select').each(function() {
                    var $field = $(this);
                    var name = ($field.attr('name') || '').toString();
                    if (!name) {
                        return;
                    }
                    var pattern = new RegExp(optionExtraGroupsKey + '\\[\\d+\\]');
                    name = name.replace(pattern, optionExtraGroupsKey + '[' + groupIndex + ']');
                    $field.attr('name', name);
                });

                $group.find('tbody tr').each(function(itemIndex) {
                    $(this).find('input, textarea, select').each(function() {
                        var $field = $(this);
                        var name = ($field.attr('name') || '').toString();
                        if (!name) {
                            return;
                        }
                        name = name.replace(/\[items\]\[\d+\]/, '[items][' + itemIndex + ']');
                        $field.attr('name', name);
                    });
                });
            });

            reindexExtraSettingsLabels();
        }

        function reindexExtraSettingsLabels() {
            var $pairs = $('#configiview-extra-group-labels .configiview-extra-label-pair');
            if (!$pairs.length) {
                return;
            }

            $pairs.each(function(groupIndex) {
                var $pair = $(this);
                $pair.attr('data-group-index', groupIndex);
                $pair.find('.configiview-extra-label-input').attr('data-group-index', groupIndex);
            });
        }

        function buildExtraGroupItemRow(groupIndex, itemIndex) {
            return `
                <tr>
                    <td>
                        <input type="text" name="${optionExtraGroupsKey}[${groupIndex}][items][${itemIndex}][name]" class="regular-text" placeholder="${t('optionNamePlaceholder', 'Option name')}" />
                        <input type="hidden" name="${optionExtraGroupsKey}[${groupIndex}][items][${itemIndex}][key]" value="" />
                    </td>
                    <td>
                        <div class="floor-viz-image-field">
                            <input type="hidden" name="${optionExtraGroupsKey}[${groupIndex}][items][${itemIndex}][image]" class="floor-viz-image-url" />
                            <button type="button" class="button floor-viz-upload-btn">${t('uploadImage', 'Upload Image')}</button>
                            <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="${t('remove', 'Remove')}" aria-label="${t('remove', 'Remove')}"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                            <div class="floor-viz-image-preview"></div>
                        </div>
                    </td>
                    <td>
                        <button type="button" class="button floor-viz-remove-row floor-viz-remove-row-btn">${t('remove', 'Remove')}</button>
                    </td>
                </tr>
            `;
        }

        function buildExtraGroupCard(groupIndex) {
            var defaultLabel = t('groupLabel', 'Group') + ' ' + (groupIndex + 3);
            return `
                <div class="configiview-group-card" data-group-index="${groupIndex}">
                    <div class="configiview-admin-group-head">
                        <h2 class="configiview-group-title">${defaultLabel}</h2>
                        <button type="button" class="configiview-admin-group-toggle button-link" aria-expanded="false" aria-label="${t('toggleGroup', 'Toggle group')}" title="${t('toggleGroup', 'Toggle group')}">
                            <span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
                        </button>
                    </div>
                    <div class="configiview-admin-group-body">
                        <input type="hidden" class="configiview-group-singular" name="${optionExtraGroupsKey}[${groupIndex}][singular]" value="${defaultLabel}" />
                        <input type="hidden" class="configiview-group-plural" name="${optionExtraGroupsKey}[${groupIndex}][plural]" value="${defaultLabel}" />
                        <table class="widefat configiview-extra-group-list">
                            <thead>
                                <tr>
                                    <th>
                                        <span class="configiview-option-name-header">${defaultLabel} ${t('nameLabel', 'Name')}</span>
                                        <span class="floor-viz-tip" tabindex="0">?
                                            <span class="floor-viz-tip-text">${t('shownFrontendOptions', 'Shown in frontend options.')}</span>
                                        </span>
                                    </th>
                                    <th>
                                        ${t('uploadImageColumnLabel', t('optionImageLabel', 'Option Image'))}
                                        <span class="floor-viz-tip" tabindex="0">?
                                            <span class="floor-viz-tip-text">${t('smallImageOptionTile', 'Small image for option tile.')}</span>
                                        </span>
                                    </th>
                                    <th>${t('actionLabel', 'Action')}</th>
                                </tr>
                            </thead>
                            <tbody>
                                ${buildExtraGroupItemRow(groupIndex, 0)}
                            </tbody>
                        </table>
                        <p>
                            <button type="button" class="button configiview-add-extra-item">${t('addOptionLabel', 'Add Option')}</button>
                            <button type="button" class="button floor-viz-remove-row configiview-remove-group">${t('removeGroupLabel', 'Remove Group')}</button>
                        </p>
                    </div>
                </div>
            `;
        }

        function initAdminGroupCollapseState() {
            $('.configiview-base-group, .configiview-group-card').each(function() {
                var $group = $(this);
                var $toggle = $group.find('.configiview-admin-group-toggle').first();
                var $body = $group.find('.configiview-admin-group-body').first();
                if (!$toggle.length || !$body.length) {
                    return;
                }
                $toggle.attr('aria-expanded', 'false');
                $toggle.html('<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>');
                $body.stop(true, true).hide();
            });
        }

        applyUploadIcons();
        initAdminGroupCollapseState();
        $('#floor-viz-add-color, #floor-viz-add-pattern').on('click', function() {
            setTimeout(applyUploadIcons, 0);
        });

        $('#configiview-add-group').on('click', function(e) {
            e.preventDefault();
            var $wrap = $('#configiview-extra-groups');
            if (!$wrap.length) {
                return;
            }
            var index = $wrap.find('.configiview-group-card').length;
            $wrap.append(buildExtraGroupCard(index));
            applyUploadIcons();
            initAdminGroupCollapseState();
            reindexExtraGroups();
        });

        $(document).on('click', '.configiview-remove-group', function(e) {
            e.preventDefault();
            var $group = $(this).closest('.configiview-group-card');
            var removedGroupIndex = parseInt(($group.attr('data-group-index') || '').toString(), 10);
            $group.remove();
            if (!Number.isNaN(removedGroupIndex)) {
                $('#configiview-extra-group-labels .configiview-extra-label-pair[data-group-index="' + removedGroupIndex + '"]').remove();
            }
            reindexExtraGroups();
        });

        $(document).on('click', '.configiview-remove-base-group', function(e) {
            e.preventDefault();
            if (!isProActive) {
                return;
            }
            if (!window.confirm(t('removeGroupConfirm', 'Remove this group and all its options?'))) {
                return;
            }

            var $btn = $(this);
            var optionKey = ($btn.data('option-key') || '').toString();
            if (!optionKey) {
                return;
            }

            var $group = $btn.closest('.configiview-base-group');
            if (isProActive) {
                var baseGroup = ($group.data('base-group') || '').toString();
                if (baseGroup === 'group-1') {
                    $('#configiview-base-group-visibility-group-1').val('0');
                } else if (baseGroup === 'group-2') {
                    $('#configiview-base-group-visibility-group-2').val('0');
                }
                $group.remove();
            } else {
                var fieldId = 'configiview-remove-' + optionKey.replace(/[^a-z0-9_]/gi, '-');
                if ($('#' + fieldId).length === 0) {
                    $('<input>', {
                        type: 'hidden',
                        id: fieldId,
                        name: optionKey,
                        value: ''
                    }).appendTo('#configiview-removed-base-group-fields');
                }
                $group.find('tbody').empty();
            }
        });

        $(document).on('click', '.configiview-admin-group-toggle', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var $body = $btn.closest('.configiview-base-group, .configiview-group-card').find('.configiview-admin-group-body').first();
            if (!$body.length) {
                return;
            }

            function setToggleState(isExpanded) {
                $btn.attr('aria-expanded', isExpanded ? 'true' : 'false');
                if (isExpanded) {
                    $btn.html('<span class="dashicons dashicons-arrow-up-alt2" aria-hidden="true"></span>');
                } else {
                    $btn.html('<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>');
                }
            }

            var expanded = $btn.attr('aria-expanded') === 'true';
            if (expanded) {
                $body.stop(true, true).slideUp(180);
                setToggleState(false);
            } else {
                $body.stop(true, true).slideDown(180);
                setToggleState(true);
            }
        });

        $(document).on('click', '.configiview-add-extra-item', function(e) {
            e.preventDefault();
            var $group = $(this).closest('.configiview-group-card');
            var groupIndex = parseInt($group.attr('data-group-index'), 10) || 0;
            var $tbody = $group.find('tbody');
            var itemIndex = $tbody.find('tr').length;
            $tbody.append(buildExtraGroupItemRow(groupIndex, itemIndex));
            applyUploadIcons();
            reindexExtraGroups();
        });

        $(document).on('input', '.configiview-extra-label-input', function() {
            var $input = $(this);
            var groupIndex = parseInt(($input.data('group-index') || '').toString(), 10);
            var labelType = ($input.data('label-type') || '').toString();
            var value = ($input.val() || '').toString();
            var $groupCard = $('#configiview-extra-groups .configiview-group-card[data-group-index="' + groupIndex + '"]');
            if (!$groupCard.length) {
                return;
            }

            if (labelType === 'singular') {
                $groupCard.find('.configiview-group-singular').val(value);
                var addLabelBase = value.trim() || t('optionLabel', 'Option');
                $groupCard.find('.configiview-add-extra-item').text(t('addLabel', 'Add') + ' ' + addLabelBase);
            } else if (labelType === 'plural') {
                $groupCard.find('.configiview-group-plural').val(value);
                var heading = value.trim() || (t('groupLabel', 'Group') + ' ' + (groupIndex + 3));
                $groupCard.find('.configiview-group-title').text(heading);
            }
        });

        $('.nav-tab').on('click', function(e) {
            e.preventDefault();
            var target = $(this).attr('href');
            activateTabByTarget(target);
        });

        $('form[action="options.php"]').on('submit', function() {
            var $activeTab = $('.nav-tab.nav-tab-active');
            var target = ($activeTab.attr('href') || '#colors-patterns').toString();
            var tabName = target.replace('#', '');
            var referer = 'admin.php?page=configiview-settings&tab=' + encodeURIComponent(tabName);
            $('input[name="_wp_http_referer"]').val(referer);
        });

        var urlParams = new URLSearchParams(window.location.search);
        var tabFromQuery = (urlParams.get('tab') || '').toLowerCase();
        if (tabFromQuery) {
            activateTabByTarget('#' + tabFromQuery);
        } else {
            var $activeTab = $('.nav-tab.nav-tab-active');
            toggleSubmitForTarget($activeTab.attr('href'));
        }

        $('.floor-viz-reset-link').on('click', function(e) {
            if (!window.confirm(t('resetConfirm', 'Are you sure you want to reset all configurator data? This action cannot be undone.'))) {
                e.preventDefault();
            }
        });

        reindexExtraGroups();

        $('#configiview_activate_license_btn').on('click', function(e) {
            e.preventDefault();

            var $btn = $(this);
            var actionUrl = ($btn.data('action-url') || '').toString();
            var nonce = ($btn.data('nonce') || '').toString();
            var licenseKey = ($('#configiview_license_key').val() || '').toString();

            if (!actionUrl || !nonce) {
                return;
            }

            var $form = $('<form>', {
                method: 'post',
                action: actionUrl
            });

            $('<input>', { type: 'hidden', name: 'action', value: 'configiview_activate_license' }).appendTo($form);
            $('<input>', { type: 'hidden', name: 'configiview_activate_license_nonce', value: nonce }).appendTo($form);
            $('<input>', { type: 'hidden', name: 'configiview_license_key', value: licenseKey }).appendTo($form);

            $form.appendTo('body');
            $form.trigger('submit');
        });

        $('#configiview_remove_license_btn').on('click', function(e) {
            e.preventDefault();

            if (!window.confirm(t('removeLicenseConfirm', 'Remove saved license key from this site?'))) {
                return;
            }

            var $btn = $(this);
            var actionUrl = ($btn.data('action-url') || '').toString();
            var nonce = ($btn.data('nonce') || '').toString();

            if (!actionUrl || !nonce) {
                return;
            }

            var $form = $('<form>', {
                method: 'post',
                action: actionUrl
            });

            $('<input>', { type: 'hidden', name: 'action', value: 'configiview_remove_license' }).appendTo($form);
            $('<input>', { type: 'hidden', name: 'configiview_remove_license_nonce', value: nonce }).appendTo($form);

            $form.appendTo('body');
            $form.trigger('submit');
        });
    });
})(jQuery);
