(function($) {
    'use strict';

    $(document).ready(function() {
        const i18n = (typeof configiViewAdmin !== 'undefined') ? configiViewAdmin : {};
        const mediaTitle = i18n.mediaTitle || 'Select Image';
        const mediaButton = i18n.mediaButton || 'Use this image';
        const placeholderColorName = i18n.placeholderColorName || 'Option name';
        const placeholderPatternName = i18n.placeholderPatternName || 'Option name';
        const uploadImageText = i18n.uploadImage || 'Upload Image';
        const removeText = i18n.remove || 'Remove';
        const optionColorsKey = i18n.optionColorsKey || 'configiview_colors';
        const optionPatternsKey = i18n.optionPatternsKey || 'configiview_patterns';
        const maxItems = parseInt(i18n.maxItems, 10) || 5;
        const maxItemsMessage = i18n.maxItemsMessage || 'Maximum 5 items allowed.';
        const escapeHtml = function(value) {
            return String(value).replace(/[&<>"']/g, function(char) {
                return ({
                    '&': '&amp;',
                    '<': '&lt;',
                    '>': '&gt;',
                    '"': '&quot;',
                    "'": '&#39;'
                })[char];
            });
        };

        function toggleRemoveImageButton($field) {
            if (!$field || !$field.length) {
                return;
            }
            const hasImage = ($field.find('input[type="hidden"]').val() || '').toString().trim() !== '';
            $field.find('.floor-viz-remove-image').toggleClass('is-hidden', !hasImage);
        }

        function syncRemoveImageButtons() {
            $('.floor-viz-image-field').each(function() {
                toggleRemoveImageButton($(this));
            });
        }

        $(document).on('click', '.floor-viz-upload-btn', function(e) {
            e.preventDefault();

            const $field = $(this).closest('.floor-viz-image-field');
            const $input = $field.find('input[type="hidden"]');
            const $preview = $field.find('.floor-viz-image-preview');

            const mediaUploader = wp.media({
                title: mediaTitle,
                button: { text: mediaButton },
                multiple: false
            });

            mediaUploader.on('select', function() {
                const attachment = mediaUploader.state().get('selection').first().toJSON();
                $input.val(attachment.url);
                const $img = $('<img>', {
                    src: attachment.url,
                    css: {
                        maxWidth: '100px',
                        height: 'auto',
                        display: 'block',
                        marginTop: '10px'
                    }
                });
                $preview.empty().append($img);
                toggleRemoveImageButton($field);
            });

            mediaUploader.open();
        });

        $(document).on('click', '.floor-viz-remove-image', function(e) {
            e.preventDefault();
            const $field = $(this).closest('.floor-viz-image-field');
            $field.find('input[type="hidden"]').val('');
            $field.find('.floor-viz-image-preview').html('');
            toggleRemoveImageButton($field);
        });

        $('#floor-viz-add-color').on('click', function(e) {
            e.preventDefault();
            addRow('color');
        });

        $('#floor-viz-add-pattern').on('click', function(e) {
            e.preventDefault();
            addRow('pattern');
        });

        $(document).on('click', '.floor-viz-remove-row', function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
            syncAddButtons();
        });

        function imageField(name) {
            return `
                <div class="floor-viz-image-field">
                    <input type="hidden" name="${escapeHtml(name)}" class="floor-viz-image-url" />
                    <button type="button" class="button floor-viz-upload-btn">${escapeHtml(uploadImageText)}</button>
                    <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="${escapeHtml(removeText)}" aria-label="${escapeHtml(removeText)}"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                    <div class="floor-viz-image-preview"></div>
                </div>
            `;
        }

        function addRow(type) {
            const $tbody = $('#floor-viz-' + type + '-list tbody');
            if ($tbody.find('tr').length >= maxItems) {
                window.alert(maxItemsMessage);
                return;
            }

            const index = $tbody.find('tr').length;
            const collection = type === 'color' ? optionColorsKey : optionPatternsKey;
            const resetFieldId = 'configiview-remove-' + collection.replace(/[^a-z0-9_]/gi, '-');
            $('#' + resetFieldId).remove();
            const $addBtn = $('#floor-viz-add-' + type);
            const singular = ($addBtn.data('singular') || '').toString().trim();
            const placeholderRaw = singular ? (singular + ' name') : (type === 'color' ? placeholderColorName : placeholderPatternName);
            const placeholder = escapeHtml(placeholderRaw);

            const row = `
                <tr>
                    <td>
                        <input type="text" name="${collection}[${index}][name]" class="regular-text" placeholder="${placeholder}" />
                        <input type="hidden" name="${collection}[${index}][key]" value="" />
                    </td>
                    <td>
                        ${imageField(`${collection}[${index}][image]`)}
                    </td>
                    <td>
                        <button type="button" class="button floor-viz-remove-row floor-viz-remove-row-btn" title="${escapeHtml(removeText)}" aria-label="${escapeHtml(removeText)}">${escapeHtml(removeText)}</button>
                    </td>
                </tr>
            `;

            $tbody.append(row);
            syncAddButtons();
            syncRemoveImageButtons();
        }

        function syncAddButtons() {
            ['color', 'pattern'].forEach(function(type) {
                const $btn = $('#floor-viz-add-' + type);
                const $tbody = $('#floor-viz-' + type + '-list tbody');
                const isDisabled = $tbody.find('tr').length >= maxItems;
                $btn.prop('disabled', isDisabled);
            });
        }

        syncAddButtons();
        syncRemoveImageButtons();
    });

})(jQuery);
