<?php
/**
 * Admin Settings Page
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

// Get current settings
$option_colors_key = ConfigiView::OPTION_COLORS;
$option_patterns_key = ConfigiView::OPTION_PATTERNS;
$option_base_group_visibility_key = ConfigiView::OPTION_BASE_GROUP_VISIBILITY;
$option_combo_previews_key = ConfigiView::OPTION_COMBO_PREVIEWS;
$option_combo_visibility_key = ConfigiView::OPTION_COMBO_VISIBILITY;
$option_labels_key = ConfigiView::OPTION_LABELS;
$option_email_key = ConfigiView::OPTION_EMAIL;
$option_cta_settings_key = ConfigiView::OPTION_CTA_SETTINGS;
$option_frontend_settings_key = ConfigiView::OPTION_FRONTEND_SETTINGS;
$option_extra_groups_key = ConfigiView::OPTION_EXTRA_GROUPS;

$colors = get_option($option_colors_key, ConfigiView::get_default_colors());
$patterns = get_option($option_patterns_key, ConfigiView::get_default_patterns());
$combo_previews = get_option($option_combo_previews_key, ConfigiView::get_default_combo_previews());
if (!is_array($colors)) {
    $colors = array();
}
if (!is_array($patterns)) {
    $patterns = array();
}
if (!is_array($combo_previews)) {
    $combo_previews = array();
}
$combo_visibility = get_option($option_combo_visibility_key, array());
if (!is_array($combo_visibility)) {
    $combo_visibility = array();
}
$labels = get_option($option_labels_key, ConfigiView::get_default_labels());
$email = get_option($option_email_key, get_option('admin_email'));
$cta_settings = ConfigiView::get_cta_settings();
$frontend_settings = ConfigiView::get_frontend_settings();
$extra_groups = get_option($option_extra_groups_key, array());
if (!is_array($extra_groups)) {
    $extra_groups = array();
}
$group_one_singular = isset($labels['group_one_singular']) && $labels['group_one_singular'] !== '' ? $labels['group_one_singular'] : __('Color', 'configiview');
$group_one_plural = isset($labels['group_one_plural']) && $labels['group_one_plural'] !== '' ? $labels['group_one_plural'] : __('Colors', 'configiview');
$group_two_singular = isset($labels['group_two_singular']) && $labels['group_two_singular'] !== '' ? $labels['group_two_singular'] : __('Pattern', 'configiview');
$group_two_plural = isset($labels['group_two_plural']) && $labels['group_two_plural'] !== '' ? $labels['group_two_plural'] : __('Patterns', 'configiview');
$cta_mode = isset($cta_settings['mode']) ? (string) $cta_settings['mode'] : 'mailto';
$cta_button_label = isset($cta_settings['button_label']) ? (string) $cta_settings['button_label'] : ConfigiView::get_default_cta_button_label();
$cta_subject_template = isset($cta_settings['subject_template']) ? (string) $cta_settings['subject_template'] : ConfigiView::get_default_cta_subject();
$cta_body_template = isset($cta_settings['body_template']) ? (string) $cta_settings['body_template'] : ConfigiView::get_default_cta_body();
$cta_shortcode = isset($cta_settings['shortcode']) ? (string) $cta_settings['shortcode'] : '';
$allowed_tabs = array('colors-patterns', 'combo-previews', 'settings', 'usage', 'support');
$active_tab_raw = filter_input(INPUT_GET, 'tab', FILTER_UNSAFE_RAW);
$active_tab = is_string($active_tab_raw) ? sanitize_key((string) wp_unslash($active_tab_raw)) : 'colors-patterns';
if (!in_array($active_tab, $allowed_tabs, true)) {
    $active_tab = 'colors-patterns';
}
$notice_nonce_raw = filter_input(INPUT_GET, 'configiview_notice_nonce', FILTER_UNSAFE_RAW);
$notice_nonce = is_string($notice_nonce_raw) ? sanitize_text_field(wp_unslash($notice_nonce_raw)) : '';
$has_valid_notice_nonce = ('' !== $notice_nonce) && wp_verify_nonce($notice_nonce, 'configiview_admin_notice');
$reset_flag_raw = filter_input(INPUT_GET, 'configiview_reset', FILTER_UNSAFE_RAW);
$reset_flag = ($has_valid_notice_nonce && is_string($reset_flag_raw)) ? sanitize_text_field(wp_unslash($reset_flag_raw)) : '';
$is_pro_active = ConfigiView::is_pro_active();
if (!$is_pro_active) {
    $extra_groups = array();
}
$base_group_visibility = ConfigiView::get_base_group_visibility();
$show_group_one = !$is_pro_active || !isset($base_group_visibility['group_1']) || (int) $base_group_visibility['group_1'] === 1;
$show_group_two = !$is_pro_active || !isset($base_group_visibility['group_2']) || (int) $base_group_visibility['group_2'] === 1;
$reset_defaults_url = wp_nonce_url(
    admin_url('admin-post.php?action=configiview_reset_defaults'),
    'configiview_reset_defaults'
);

$all_groups_for_combos = array();
if ($show_group_one) {
    $all_groups_for_combos[] = array(
        'index' => 0,
        'singular' => $group_one_singular,
        'plural' => $group_one_plural,
        'items' => is_array($colors) ? $colors : array(),
    );
}
if ($show_group_two) {
    $all_groups_for_combos[] = array(
        'index' => 1,
        'singular' => $group_two_singular,
        'plural' => $group_two_plural,
        'items' => is_array($patterns) ? $patterns : array(),
    );
}
foreach ($extra_groups as $g_index => $group) {
    /* translators: %d: Option group number. */
    $extra_singular = isset($group['singular']) && '' !== trim((string) $group['singular']) ? (string) $group['singular'] : sprintf(__('Group %d', 'configiview'), (int) $g_index + 3);
    $extra_plural = isset($group['plural']) && '' !== trim((string) $group['plural']) ? (string) $group['plural'] : $extra_singular;
    $extra_items = (isset($group['items']) && is_array($group['items'])) ? $group['items'] : array();
    $all_groups_for_combos[] = array(
        'index' => (int) $g_index + 2,
        'singular' => $extra_singular,
        'plural' => $extra_plural,
        'items' => $extra_items,
    );
}
$cta_placeholder_examples = array();
foreach ($all_groups_for_combos as $group_meta) {
    $token_index = (int) $group_meta['index'] + 1;
    $token_label = isset($group_meta['singular']) ? (string) $group_meta['singular'] : '';
    if ('' === trim($token_label)) {
        /* translators: %d: Option group number. */
        $token_label = sprintf(__('Group %d', 'configiview'), $token_index);
    }
    $cta_placeholder_examples[] = '{group' . $token_index . '} = ' . $token_label;
}
$cta_placeholder_help = implode(', ', $cta_placeholder_examples);
$accordion_enabled = isset($frontend_settings['accordion_enabled']) && (int) $frontend_settings['accordion_enabled'] === 1 ? 1 : 0;
$has_more_than_two_groups = count($all_groups_for_combos) > 2;
?>

<div class="wrap floor-viz-admin">
    <div class="floor-viz-sticky-head">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <p class="floor-viz-subtitle"><?php esc_html_e('Manage options, combinations & previews', 'configiview'); ?></p>
        <h2 class="nav-tab-wrapper">
            <a href="#colors-patterns" class="nav-tab <?php echo ('colors-patterns' === $active_tab) ? 'nav-tab-active' : ''; ?>"><span class="dashicons dashicons-screenoptions" aria-hidden="true"></span><?php esc_html_e('Options', 'configiview'); ?></a>
            <a href="#combo-previews" class="nav-tab <?php echo ('combo-previews' === $active_tab) ? 'nav-tab-active' : ''; ?>"><span class="dashicons dashicons-images-alt2" aria-hidden="true"></span><?php esc_html_e('Combination Previews', 'configiview'); ?></a>
            <a href="#settings" class="nav-tab <?php echo ('settings' === $active_tab) ? 'nav-tab-active' : ''; ?>"><span class="dashicons dashicons-admin-generic" aria-hidden="true"></span><?php esc_html_e('Settings', 'configiview'); ?></a>
            <a href="#support" class="nav-tab <?php echo ('support' === $active_tab) ? 'nav-tab-active' : ''; ?>"><span class="dashicons dashicons-sos" aria-hidden="true"></span><?php esc_html_e('Support', 'configiview'); ?></a>
            <a href="#usage" class="nav-tab <?php echo ('usage' === $active_tab) ? 'nav-tab-active' : ''; ?>"><span class="dashicons dashicons-editor-help" aria-hidden="true"></span><?php esc_html_e('Instructions', 'configiview'); ?></a>
        </h2>
    </div>

    <?php if ('1' === $reset_flag): ?>
        <div class="notice notice-success is-dismissible"><p><?php esc_html_e('All configurator data has been reset.', 'configiview'); ?></p></div>
    <?php endif; ?>
    <form method="post" action="options.php">
        <?php settings_fields('configiview_settings'); ?>
        
        <!-- Colors and Patterns Tab -->
        <div id="colors-patterns" class="floor-viz-tab-content" style="<?php echo ('colors-patterns' === $active_tab) ? '' : 'display: none;'; ?>">
            <p class="description"><?php esc_html_e('You can rename option group labels from the Settings tab.', 'configiview'); ?></p>
            <div id="configiview-base-group-visibility-fields">
                <input type="hidden" id="configiview-base-group-visibility-group-1" name="<?php echo esc_attr($option_base_group_visibility_key); ?>[group_1]" value="<?php echo esc_attr($show_group_one ? '1' : '0'); ?>" />
                <input type="hidden" id="configiview-base-group-visibility-group-2" name="<?php echo esc_attr($option_base_group_visibility_key); ?>[group_2]" value="<?php echo esc_attr($show_group_two ? '1' : '0'); ?>" />
            </div>
            <?php if ($show_group_one): ?>
            <div class="configiview-base-group" data-base-group="group-1">
            <div class="configiview-admin-group-head">
                <h2><?php echo esc_html($group_one_plural); ?></h2>
                <?php if ($is_pro_active): ?>
                    <button type="button" class="configiview-admin-group-toggle button-link" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle group', 'configiview'); ?>" title="<?php esc_attr_e('Toggle group', 'configiview'); ?>">
                        <span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
                    </button>
                <?php endif; ?>
            </div>
            <div class="configiview-admin-group-body">
            <table class="widefat" id="floor-viz-color-list">
                <thead>
                    <tr>
                        <th>
                            <?php /* translators: %s: Group singular label. */ ?>
                            <?php echo esc_html(sprintf(__('%s Name', 'configiview'), $group_one_singular)); ?>
                            <span class="floor-viz-tip" tabindex="0">?
                                <span class="floor-viz-tip-text"><?php esc_html_e('Shown in frontend options.', 'configiview'); ?></span>
                            </span>
                        </th>
                        <th>
                            <?php esc_html_e('Option Image', 'configiview'); ?>
                            <span class="floor-viz-tip" tabindex="0">?
                                <span class="floor-viz-tip-text"><?php esc_html_e('Small image for option tile.', 'configiview'); ?></span>
                            </span>
                        </th>
                        <th><?php esc_html_e('Action', 'configiview'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($colors)): ?>
                        <?php foreach ($colors as $index => $color): ?>
                            <?php
                            $color_name = isset($color['name']) ? (string) $color['name'] : '';
                            $color_key = isset($color['key']) ? (string) $color['key'] : ConfigiView::normalize_choice_key($color_name);
                            $color_image = isset($color['image']) ? (string) $color['image'] : '';
                            ?>
                            <tr>
                                <td>
                                    <?php /* translators: %s: Group singular label. */ ?>
                                    <input type="text" name="<?php echo esc_attr($option_colors_key); ?>[<?php echo esc_attr((string) $index); ?>][name]" value="<?php echo esc_attr($color_name); ?>" class="regular-text" placeholder="<?php echo esc_attr(sprintf(__('%s name', 'configiview'), $group_one_singular)); ?>" />
                                    <input type="hidden" name="<?php echo esc_attr($option_colors_key); ?>[<?php echo esc_attr((string) $index); ?>][key]" value="<?php echo esc_attr($color_key); ?>" />
                                </td>
                                <td>
                                    <div class="floor-viz-image-field">
                                        <input type="hidden" name="<?php echo esc_attr($option_colors_key); ?>[<?php echo esc_attr((string) $index); ?>][image]" value="<?php echo esc_attr($color_image); ?>" class="floor-viz-image-url" />
                                        <button type="button" class="button floor-viz-upload-btn"><?php esc_html_e('Upload Image', 'configiview'); ?></button>
                                        <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="<?php esc_attr_e('Clear image', 'configiview'); ?>" aria-label="<?php esc_attr_e('Clear image', 'configiview'); ?>"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                                        <div class="floor-viz-image-preview">
                                            <?php if (!empty($color_image)): ?>
                                                <img src="<?php echo esc_url($color_image); ?>" style="max-width: 100px; display: block; margin-top: 10px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <button type="button" class="button floor-viz-remove-row floor-viz-remove-row-btn" title="<?php esc_attr_e('Remove row', 'configiview'); ?>" aria-label="<?php esc_attr_e('Remove row', 'configiview'); ?>"><?php esc_html_e('Remove', 'configiview'); ?></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
            <p>
                <?php /* translators: %s: Group singular label. */ ?>
                <button type="button" id="floor-viz-add-color" class="button" data-singular="<?php echo esc_attr($group_one_singular); ?>"><?php echo esc_html(sprintf(__('Add %s', 'configiview'), $group_one_singular)); ?></button>
                <?php if ($is_pro_active): ?>
                <button type="button" class="button floor-viz-remove-row configiview-remove-base-group" data-option-key="<?php echo esc_attr($option_colors_key); ?>"><?php esc_html_e('Remove Group', 'configiview'); ?></button>
                <?php endif; ?>
            </p>
            </div>
            </div>
            <?php endif; ?>

            <?php if ($show_group_two): ?>
            <div class="configiview-base-group" data-base-group="group-2">
            <div class="configiview-admin-group-head">
                <h2><?php echo esc_html($group_two_plural); ?></h2>
                <?php if ($is_pro_active): ?>
                    <button type="button" class="configiview-admin-group-toggle button-link" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle group', 'configiview'); ?>" title="<?php esc_attr_e('Toggle group', 'configiview'); ?>">
                        <span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
                    </button>
                <?php endif; ?>
            </div>
            <div class="configiview-admin-group-body">
            <table class="widefat" id="floor-viz-pattern-list">
                <thead>
                    <tr>
                        <th>
                            <?php /* translators: %s: Group singular label. */ ?>
                            <?php echo esc_html(sprintf(__('%s Name', 'configiview'), $group_two_singular)); ?>
                            <span class="floor-viz-tip" tabindex="0">?
                                <span class="floor-viz-tip-text"><?php esc_html_e('Shown in frontend options.', 'configiview'); ?></span>
                            </span>
                        </th>
                        <th>
                            <?php esc_html_e('Option Image', 'configiview'); ?>
                            <span class="floor-viz-tip" tabindex="0">?
                                <span class="floor-viz-tip-text"><?php esc_html_e('Small image for option tile.', 'configiview'); ?></span>
                            </span>
                        </th>
                        <th><?php esc_html_e('Action', 'configiview'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($patterns)): ?>
                        <?php foreach ($patterns as $index => $pattern): ?>
                            <?php
                            $pattern_name = isset($pattern['name']) ? (string) $pattern['name'] : '';
                            $pattern_key = isset($pattern['key']) ? (string) $pattern['key'] : ConfigiView::normalize_choice_key($pattern_name);
                            $pattern_image = isset($pattern['image']) ? (string) $pattern['image'] : '';
                            ?>
                            <tr>
                                <td>
                                    <?php /* translators: %s: Group singular label. */ ?>
                                    <input type="text" name="<?php echo esc_attr($option_patterns_key); ?>[<?php echo esc_attr((string) $index); ?>][name]" value="<?php echo esc_attr($pattern_name); ?>" class="regular-text" placeholder="<?php echo esc_attr(sprintf(__('%s name', 'configiview'), $group_two_singular)); ?>" />
                                    <input type="hidden" name="<?php echo esc_attr($option_patterns_key); ?>[<?php echo esc_attr((string) $index); ?>][key]" value="<?php echo esc_attr($pattern_key); ?>" />
                                </td>
                                <td>
                                    <div class="floor-viz-image-field">
                                        <input type="hidden" name="<?php echo esc_attr($option_patterns_key); ?>[<?php echo esc_attr((string) $index); ?>][image]" value="<?php echo esc_attr($pattern_image); ?>" class="floor-viz-image-url" />
                                        <button type="button" class="button floor-viz-upload-btn"><?php esc_html_e('Upload Image', 'configiview'); ?></button>
                                        <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="<?php esc_attr_e('Clear image', 'configiview'); ?>" aria-label="<?php esc_attr_e('Clear image', 'configiview'); ?>"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                                        <div class="floor-viz-image-preview">
                                            <?php if (!empty($pattern_image)): ?>
                                                <img src="<?php echo esc_url($pattern_image); ?>" style="max-width: 100px; display: block; margin-top: 10px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <button type="button" class="button floor-viz-remove-row floor-viz-remove-row-btn" title="<?php esc_attr_e('Remove row', 'configiview'); ?>" aria-label="<?php esc_attr_e('Remove row', 'configiview'); ?>"><?php esc_html_e('Remove', 'configiview'); ?></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
            <p>
                <?php /* translators: %s: Group singular label. */ ?>
                <button type="button" id="floor-viz-add-pattern" class="button" data-singular="<?php echo esc_attr($group_two_singular); ?>"><?php echo esc_html(sprintf(__('Add %s', 'configiview'), $group_two_singular)); ?></button>
                <?php if ($is_pro_active): ?>
                <button type="button" class="button floor-viz-remove-row configiview-remove-base-group" data-option-key="<?php echo esc_attr($option_patterns_key); ?>"><?php esc_html_e('Remove Group', 'configiview'); ?></button>
                <?php endif; ?>
            </p>
            </div>
            </div>
            <?php endif; ?>

            <div id="configiview-removed-base-group-fields"></div>

            <?php if ($is_pro_active): ?>
                <div id="configiview-extra-groups">
                    <?php foreach ($extra_groups as $g_index => $group): ?>
                        <?php
                        $g_singular = isset($group['singular']) ? (string) $group['singular'] : '';
                        $g_plural = isset($group['plural']) ? (string) $group['plural'] : '';
                        $g_items = (isset($group['items']) && is_array($group['items'])) ? $group['items'] : array();
                        ?>
                        <div class="configiview-group-card" data-group-index="<?php echo esc_attr((string) $g_index); ?>">
                            <div class="configiview-admin-group-head">
                                <h2 class="configiview-group-title"><?php echo esc_html($g_plural); ?></h2>
                                <button type="button" class="configiview-admin-group-toggle button-link" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle group', 'configiview'); ?>" title="<?php esc_attr_e('Toggle group', 'configiview'); ?>">
                                    <span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="configiview-admin-group-body">
                            <input type="hidden" class="configiview-group-singular" name="<?php echo esc_attr($option_extra_groups_key); ?>[<?php echo esc_attr((string) $g_index); ?>][singular]" value="<?php echo esc_attr($g_singular); ?>" />
                            <input type="hidden" class="configiview-group-plural" name="<?php echo esc_attr($option_extra_groups_key); ?>[<?php echo esc_attr((string) $g_index); ?>][plural]" value="<?php echo esc_attr($g_plural); ?>" />
                            <table class="widefat configiview-extra-group-list">
                                <thead>
                                <tr>
                                    <th>
                                        <?php /* translators: %s: Group singular label. */ ?>
                                        <span class="configiview-option-name-header"><?php echo esc_html(sprintf(__('%s Name', 'configiview'), $g_singular)); ?></span>
                                        <span class="floor-viz-tip" tabindex="0">?
                                            <span class="floor-viz-tip-text"><?php esc_html_e('Shown in frontend options.', 'configiview'); ?></span>
                                        </span>
                                    </th>
                                    <th>
                                        <?php esc_html_e('Option Image', 'configiview'); ?>
                                        <span class="floor-viz-tip" tabindex="0">?
                                            <span class="floor-viz-tip-text"><?php esc_html_e('Small image for option tile.', 'configiview'); ?></span>
                                        </span>
                                    </th>
                                    <th><?php esc_html_e('Action', 'configiview'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($g_items as $i_index => $item): ?>
                                    <?php
                                    $i_name = isset($item['name']) ? (string) $item['name'] : '';
                                    $i_key = isset($item['key']) ? (string) $item['key'] : ConfigiView::normalize_choice_key($i_name);
                                    $i_image = isset($item['image']) ? (string) $item['image'] : '';
                                    ?>
                                    <tr>
                                        <td>
                                            <input type="text" name="<?php echo esc_attr($option_extra_groups_key); ?>[<?php echo esc_attr((string) $g_index); ?>][items][<?php echo esc_attr((string) $i_index); ?>][name]" class="regular-text" value="<?php echo esc_attr($i_name); ?>" placeholder="<?php esc_attr_e('Option name', 'configiview'); ?>" />
                                            <input type="hidden" name="<?php echo esc_attr($option_extra_groups_key); ?>[<?php echo esc_attr((string) $g_index); ?>][items][<?php echo esc_attr((string) $i_index); ?>][key]" value="<?php echo esc_attr($i_key); ?>" />
                                        </td>
                                        <td>
                                            <div class="floor-viz-image-field">
                                                <input type="hidden" name="<?php echo esc_attr($option_extra_groups_key); ?>[<?php echo esc_attr((string) $g_index); ?>][items][<?php echo esc_attr((string) $i_index); ?>][image]" value="<?php echo esc_attr($i_image); ?>" class="floor-viz-image-url" />
                                                <button type="button" class="button floor-viz-upload-btn"><?php esc_html_e('Upload Image', 'configiview'); ?></button>
                                                <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="<?php esc_attr_e('Clear image', 'configiview'); ?>" aria-label="<?php esc_attr_e('Clear image', 'configiview'); ?>"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                                                <div class="floor-viz-image-preview">
                                                    <?php if (!empty($i_image)): ?>
                                                        <img src="<?php echo esc_url($i_image); ?>" style="max-width: 100px; display: block; margin-top: 10px;">
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <button type="button" class="button floor-viz-remove-row floor-viz-remove-row-btn"><?php esc_html_e('Remove', 'configiview'); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                            <p>
                                <?php /* translators: %s: Group singular label. */ ?>
                                <button type="button" class="button configiview-add-extra-item"><?php echo esc_html(sprintf(__('Add %s', 'configiview'), $g_singular)); ?></button>
                                <button type="button" class="button floor-viz-remove-row configiview-remove-group"><?php esc_html_e('Remove Group', 'configiview'); ?></button>
                            </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <p><button type="button" id="configiview-add-group" class="button"><?php esc_html_e('Add Group', 'configiview'); ?></button></p>
            <?php endif; ?>
        </div>

        <div id="combo-previews" class="floor-viz-tab-content" style="<?php echo ('combo-previews' === $active_tab) ? '' : 'display: none;'; ?>">
            <h2><?php esc_html_e('Combination Previews', 'configiview'); ?></h2>
            <p class="description"><?php esc_html_e('Upload one preview image for each option combination across all groups.', 'configiview'); ?></p>
            <p class="description"><?php esc_html_e('If you just added options, save changes first so new combinations appear here. Renaming labels keeps the same combination keys.', 'configiview'); ?></p>

            <div class="configiview-combo-table-wrap">
            <table class="widefat" id="floor-viz-combo-preview-list">
                <thead>
                    <tr>
                        <?php foreach ($all_groups_for_combos as $group_meta): ?>
                            <th><?php echo esc_html($group_meta['singular']); ?></th>
                        <?php endforeach; ?>
                        <th><?php esc_html_e('Preview Image', 'configiview'); ?></th>
                        <?php if ($is_pro_active): ?>
                            <th><?php esc_html_e('Frontend', 'configiview'); ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $combo_item_lists = array();
                    $combo_has_all_groups = true;
                    foreach ($all_groups_for_combos as $group_meta) {
                        $normalized_items = array();
                        foreach ($group_meta['items'] as $item) {
                            $item_name = isset($item['name']) ? (string) $item['name'] : '';
                            $item_key = isset($item['key']) ? ConfigiView::normalize_choice_key($item['key']) : ConfigiView::normalize_choice_key($item_name);
                            if ('' === $item_key || '' === trim($item_name)) {
                                continue;
                            }
                            $normalized_items[] = array(
                                'name' => $item_name,
                                'key' => $item_key,
                            );
                        }
                        if (empty($normalized_items)) {
                            $combo_has_all_groups = false;
                            break;
                        }
                        $combo_item_lists[] = $normalized_items;
                    }

                    $combo_rows = array();
                    if ($combo_has_all_groups) {
                        $build_rows = function($lists, $depth = 0, $selected = array()) use (&$build_rows, &$combo_rows) {
                            if ($depth >= count($lists)) {
                                $combo_rows[] = $selected;
                                return;
                            }
                            foreach ($lists[$depth] as $item) {
                                $next = $selected;
                                $next[] = $item;
                                $build_rows($lists, $depth + 1, $next);
                            }
                        };
                        $build_rows($combo_item_lists, 0, array());
                    }
                    ?>
                    <?php if (!empty($combo_rows)): ?>
                        <?php foreach ($combo_rows as $combo_parts): ?>
                            <?php
                            $combo_keys = array();
                            foreach ($combo_parts as $part) {
                                $combo_keys[] = $part['key'];
                            }
                            $combo_key = implode('|', $combo_keys);
                            $combo_image = isset($combo_previews[$combo_key]) ? $combo_previews[$combo_key] : '';
                            $combo_state = isset($combo_visibility[$combo_key]) ? sanitize_key((string) $combo_visibility[$combo_key]) : 'show';
                            if (!in_array($combo_state, array('show', 'hide'), true)) {
                                $combo_state = 'show';
                            }
                            ?>
                            <tr>
                                <?php foreach ($combo_parts as $part): ?>
                                    <td><?php echo esc_html($part['name']); ?></td>
                                <?php endforeach; ?>
                                <td>
                                    <div class="floor-viz-image-field">
                                        <input type="hidden" name="<?php echo esc_attr($option_combo_previews_key); ?>[<?php echo esc_attr($combo_key); ?>]" value="<?php echo esc_attr($combo_image); ?>" class="floor-viz-image-url" />
                                        <button type="button" class="button floor-viz-upload-btn"><?php esc_html_e('Upload Image', 'configiview'); ?></button>
                                        <button type="button" class="button floor-viz-remove-image floor-viz-remove-icon" title="<?php esc_attr_e('Clear image', 'configiview'); ?>" aria-label="<?php esc_attr_e('Clear image', 'configiview'); ?>"><span class="dashicons dashicons-no-alt" aria-hidden="true"></span></button>
                                        <div class="floor-viz-image-preview">
                                            <?php if (!empty($combo_image)): ?>
                                                <img src="<?php echo esc_url($combo_image); ?>" style="max-width: 120px; display: block; margin-top: 10px;">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <?php if ($is_pro_active): ?>
                                    <td>
                                        <select name="<?php echo esc_attr($option_combo_visibility_key); ?>[<?php echo esc_attr($combo_key); ?>]">
                                            <option value="show" <?php selected('show', $combo_state); ?>><?php esc_html_e('Show', 'configiview'); ?></option>
                                            <option value="hide" <?php selected('hide', $combo_state); ?>><?php esc_html_e('Hide', 'configiview'); ?></option>
                                        </select>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="<?php echo esc_attr((string) (count($all_groups_for_combos) + 1 + ($is_pro_active ? 1 : 0))); ?>">
                                <?php esc_html_e('Each group needs at least one option before combinations can be generated.', 'configiview'); ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            </div>
        </div>
        
        <!-- Settings Tab -->
        <div id="settings" class="floor-viz-tab-content" style="<?php echo ('settings' === $active_tab) ? '' : 'display: none;'; ?>">
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e('Option Group Labels', 'configiview'); ?></th>
                    <td>
                        <p class="description"><?php esc_html_e('Example: Lace/Laces and Base/Bases. These labels are used in admin, frontend, and inquiry summary.', 'configiview'); ?></p>
                        <div class="floor-viz-label-grid">
                            <p>
                                <label class="floor-viz-label-row">
                                <?php esc_html_e('Group 1 singular', 'configiview'); ?>
                                <input type="text" name="<?php echo esc_attr($option_labels_key); ?>[group_one_singular]" value="<?php echo esc_attr($group_one_singular); ?>" class="regular-text floor-viz-label-input" />
                                </label>
                            </p>
                            <p>
                                <label class="floor-viz-label-row">
                                <?php esc_html_e('Group 1 plural', 'configiview'); ?>
                                <input type="text" name="<?php echo esc_attr($option_labels_key); ?>[group_one_plural]" value="<?php echo esc_attr($group_one_plural); ?>" class="regular-text floor-viz-label-input" />
                                </label>
                            </p>
                            <p>
                                <label class="floor-viz-label-row">
                                <?php esc_html_e('Group 2 singular', 'configiview'); ?>
                                <input type="text" name="<?php echo esc_attr($option_labels_key); ?>[group_two_singular]" value="<?php echo esc_attr($group_two_singular); ?>" class="regular-text floor-viz-label-input" />
                                </label>
                            </p>
                            <p>
                                <label class="floor-viz-label-row">
                                <?php esc_html_e('Group 2 plural', 'configiview'); ?>
                                <input type="text" name="<?php echo esc_attr($option_labels_key); ?>[group_two_plural]" value="<?php echo esc_attr($group_two_plural); ?>" class="regular-text floor-viz-label-input" />
                                </label>
                            </p>
                        </div>
                        <?php if ($is_pro_active && !empty($extra_groups)): ?>
                            <div id="configiview-extra-group-labels">
                            <?php foreach ($extra_groups as $g_index => $group): ?>
                                <?php
                                $g_label_number = (int) $g_index + 3;
                                /* translators: %d: Option group number. */
                                $g_singular = isset($group['singular']) && '' !== trim((string) $group['singular']) ? (string) $group['singular'] : sprintf(__('Group %d', 'configiview'), $g_label_number);
                                $g_plural = isset($group['plural']) && '' !== trim((string) $group['plural']) ? (string) $group['plural'] : $g_singular;
                                ?>
                                <div class="configiview-extra-label-pair" data-group-index="<?php echo esc_attr((string) $g_index); ?>">
                                <p>
                                    <label class="floor-viz-label-row">
                                        <?php /* translators: %d: Option group number. */ ?>
                                        <?php echo esc_html(sprintf(__('Group %d singular', 'configiview'), $g_label_number)); ?>
                                        <input type="text" value="<?php echo esc_attr($g_singular); ?>" class="regular-text floor-viz-label-input configiview-extra-label-input" data-group-index="<?php echo esc_attr((string) $g_index); ?>" data-label-type="singular" />
                                    </label>
                                </p>
                                <p>
                                    <label class="floor-viz-label-row">
                                        <?php /* translators: %d: Option group number. */ ?>
                                        <?php echo esc_html(sprintf(__('Group %d plural', 'configiview'), $g_label_number)); ?>
                                        <input type="text" value="<?php echo esc_attr($g_plural); ?>" class="regular-text floor-viz-label-input configiview-extra-label-input" data-group-index="<?php echo esc_attr((string) $g_index); ?>" data-label-type="plural" />
                                    </label>
                                </p>
                                </div>
                            <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Frontend Group Panels', 'configiview'); ?></th>
                    <td>
                        <?php if ($is_pro_active && $has_more_than_two_groups): ?>
                            <label>
                                <input type="hidden" name="<?php echo esc_attr($option_frontend_settings_key); ?>[accordion_enabled]" value="0" />
                                <input type="checkbox" name="<?php echo esc_attr($option_frontend_settings_key); ?>[accordion_enabled]" value="1" <?php checked(1, $accordion_enabled); ?> />
                                <?php esc_html_e('Compact group panels (one open at a time)', 'configiview'); ?>
                            </label>
                            <p class="description"><?php esc_html_e('Recommended when using more than 2 groups. On frontend, users click a group title to open it.', 'configiview'); ?></p>
                        <?php elseif ($is_pro_active): ?>
                            <p class="description"><?php esc_html_e('This option appears when more than two groups exist.', 'configiview'); ?></p>
                        <?php else: ?>
                            <p class="description"><?php esc_html_e('This option is available when more than two groups exist.', 'configiview'); ?></p>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Inquiry Email Address', 'configiview'); ?></th>
                    <td>
                        <input type="email" name="<?php echo esc_attr($option_email_key); ?>" value="<?php echo esc_attr($email); ?>" class="regular-text" />
                        <p class="description"><?php esc_html_e('The quick inquiry button will open a mail draft to this address.', 'configiview'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e('Inquiry Block', 'configiview'); ?></th>
                    <td>
                        <?php if ($is_pro_active): ?>
                            <fieldset>
                                <label style="display:block; margin-bottom: 8px;">
                                    <input type="radio" class="configiview-cta-mode" name="<?php echo esc_attr($option_cta_settings_key); ?>[mode]" value="mailto" <?php checked('mailto', $cta_mode); ?> />
                                    <?php esc_html_e('Mail button', 'configiview'); ?>
                                </label>
                                <label style="display:block; margin-bottom: 12px;">
                                    <input type="radio" class="configiview-cta-mode" name="<?php echo esc_attr($option_cta_settings_key); ?>[mode]" value="shortcode" <?php checked('shortcode', $cta_mode); ?> />
                                    <?php esc_html_e('Contact form shortcode', 'configiview'); ?>
                                </label>

                                <p>
                                    <label>
                                        <?php esc_html_e('Button Label', 'configiview'); ?><br />
                                        <input type="text" name="<?php echo esc_attr($option_cta_settings_key); ?>[button_label]" value="<?php echo esc_attr($cta_button_label); ?>" class="regular-text" />
                                    </label>
                                </p>
                                <p>
                                    <label>
                                        <?php esc_html_e('Email Subject Template', 'configiview'); ?><br />
                                        <input type="text" name="<?php echo esc_attr($option_cta_settings_key); ?>[subject_template]" value="<?php echo esc_attr($cta_subject_template); ?>" class="regular-text" />
                                    </label>
                                </p>
                                <p>
                                    <label>
                                        <?php esc_html_e('Email Body Template', 'configiview'); ?><br />
                                        <textarea name="<?php echo esc_attr($option_cta_settings_key); ?>[body_template]" rows="4" class="large-text"><?php echo esc_textarea($cta_body_template); ?></textarea>
                                    </label>
                                </p>
                                <p>
                                    <label>
                                        <?php esc_html_e('Form Shortcode', 'configiview'); ?><br />
                                        <input type="text" name="<?php echo esc_attr($option_cta_settings_key); ?>[shortcode]" value="<?php echo esc_attr($cta_shortcode); ?>" class="regular-text" placeholder="[contact-form-7 id=&quot;123&quot;]" />
                                    </label>
                                </p>
                                <p class="description">
                                    <?php esc_html_e('Use group placeholders in templates. Example:', 'configiview'); ?>
                                    <?php echo esc_html($cta_placeholder_help); ?>
                                </p>
                            </fieldset>
                        <?php else: ?>
                            <p class="description"><?php esc_html_e('Customize inquiry text templates or replace the button with your contact form shortcode.', 'configiview'); ?></p>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>

            <div class="floor-viz-reset-card">
                <h3><?php esc_html_e('Reset All Data', 'configiview'); ?></h3>
                <p class="description"><?php esc_html_e('This removes all colors, patterns, and combination previews you added.', 'configiview'); ?></p>
                <a href="<?php echo esc_url($reset_defaults_url); ?>" class="button button-secondary floor-viz-reset-link"><?php esc_html_e('RESET', 'configiview'); ?></a>
            </div>
        </div>

        <div id="support" class="floor-viz-tab-content" style="<?php echo ('support' === $active_tab) ? '' : 'display: none;'; ?>">
            <h2><?php esc_html_e('Community Support', 'configiview'); ?></h2>
            <p><?php esc_html_e('Support is provided via the official WordPress.org support forum. Feel free to ask questions, report issues, or get help from the community.', 'configiview'); ?></p>
            <p style="margin-top: 14px;">
                <a class="button button-secondary" href="https://wordpress.org/support/plugin/configiview/" target="_blank" rel="noopener noreferrer">
                    <?php esc_html_e('Open WordPress.org Support Forum', 'configiview'); ?>
                </a>
            </p>
        </div>
        
        <!-- Usage Tab -->
        <div id="usage" class="floor-viz-tab-content" style="<?php echo ('usage' === $active_tab) ? '' : 'display: none;'; ?>">
            <h2><?php esc_html_e('Instructions', 'configiview'); ?></h2>
            
            <h3><?php esc_html_e('Basic Shortcode', 'configiview'); ?></h3>
            <p><?php esc_html_e('Copy and paste this shortcode into any page or post:', 'configiview'); ?></p>
            <code class="floor-viz-code-block">[configiview]</code>

            <h3><?php esc_html_e('Shortcode Without CTA Banner', 'configiview'); ?></h3>
            <p><?php esc_html_e('To hide the bottom CTA banner, use:', 'configiview'); ?></p>
            <code class="floor-viz-code-block">[configiview show_cta="no"]</code>
            
            <h3><?php esc_html_e('Adding Images', 'configiview'); ?></h3>
            <ol>
                <li><?php esc_html_e('Go to the "Options" tab', 'configiview'); ?></li>
                <li><?php esc_html_e('Click "Add Color" or "Add Pattern"', 'configiview'); ?></li>
                <li><?php esc_html_e('Enter a name (e.g. "RAL 7032")', 'configiview'); ?></li>
                <li><?php esc_html_e('Click "Upload Image" and select an image from the media library', 'configiview'); ?></li>
                <li><?php esc_html_e('Click "Save Changes" at the bottom of the page', 'configiview'); ?></li>
            </ol>
            
            <h3><?php esc_html_e('Image Recommendations', 'configiview'); ?></h3>
            <ul>
                <li><strong><?php esc_html_e('Colors:', 'configiview'); ?></strong> <?php esc_html_e('Use images that are 200x200px or larger', 'configiview'); ?></li>
                <li><strong><?php esc_html_e('Patterns:', 'configiview'); ?></strong> <?php esc_html_e('Use images that are 200x200px or larger', 'configiview'); ?></li>
                <li><strong><?php esc_html_e('Format:', 'configiview'); ?></strong> <?php esc_html_e('JPG or PNG', 'configiview'); ?></li>
                <li><strong><?php esc_html_e('File size:', 'configiview'); ?></strong> <?php esc_html_e('Under 500KB for faster loading', 'configiview'); ?></li>
            </ul>
        </div>
        
        <div id="configiview-submit-wrap" style="<?php echo in_array($active_tab, array('usage', 'support'), true) ? 'display:none;' : ''; ?>">
            <?php submit_button(__('Save Changes', 'configiview')); ?>
        </div>
    </form>

</div>

<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
