/**
 * ConFab Admin JavaScript
 * FILE: assets/js/confab-admin.js
 *
 * Administrative interface JavaScript for ConFab plugin including datepicker
 * initialization and admin form enhancements.
 *
 * @package confab
 * @subpackage Assets\JavaScript
 * @since 2.0.0
 */

( function( $ ) {
	'use strict';

	/**
	 * Initialize admin interface components when DOM is ready
	 *
	 * @since 2.0.0
	 */
	$( document ).ready( function() {
		confab_init_datepicker();
	});

	/**
	 * Initialize jQuery datepicker for session date fields
	 *
	 * Configures datepicker with WordPress-friendly date format and
	 * enhanced navigation controls for session scheduling.
	 *
	 * @since 2.0.0
	 */
	function confab_init_datepicker() {
		var $dateField = $( '#confab-session-date' );
		
		if ( $dateField.length ) {
			$dateField.datepicker({
				dateFormat: 'yy-mm-dd',
				changeMonth: true,
				changeYear: true,
				showButtonPanel: true,
				closeText: 'Clear',
				beforeShow: function( input, inst ) {
					// Add clear button functionality
					setTimeout( function() {
						var buttonPane = $( input ).datepicker( "widget" ).find( ".ui-datepicker-buttonpane" );
						var btn = $( '<button class="ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all" type="button">Clear</button>' );
						btn.unbind( "click" ).bind( "click", function() {
							$.datepicker._clearDate( input );
						});
						btn.appendTo( buttonPane );
					}, 1 );
				}
			});
		}
	}

})( jQuery );