/**
 * ConFab Tab Navigation
 * FILE: assets/js/confab-tabs.js
 *
 * Handles client-side tab switching for multi-date conference schedules.
 * Provides instant panel switching without page reload while maintaining
 * WCAG accessibility compliance with proper ARIA attributes.
 *
 * @package confab
 * @subpackage Assets\JavaScript
 * @since 2.1.0
 */

document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.confab-tabs-list-button');
    
    if (tabButtons.length === 0) {
        return; // No tabs on page
    }
    
    tabButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetPanelId = this.getAttribute('aria-controls');
            const targetPanel = document.getElementById(targetPanelId);
            
            if (!targetPanel) {
                return; // Safety check
            }
            
            // Hide all panels
            document.querySelectorAll('.confab-tabs-panel').forEach(function(panel) {
                panel.setAttribute('hidden', '');
            });
            
            // Deselect all buttons
            tabButtons.forEach(function(btn) {
                btn.setAttribute('aria-selected', 'false');
                btn.setAttribute('tabindex', '-1');
            });
            
            // Show target panel
            targetPanel.removeAttribute('hidden');
            
            // Select clicked button
            this.setAttribute('aria-selected', 'true');
            this.setAttribute('tabindex', '0');
            this.focus(); // Keyboard accessibility
        });
        
        // Keyboard navigation support
        button.addEventListener('keydown', function(e) {
            let targetButton = null;
            
            if (e.key === 'ArrowLeft') {
                targetButton = this.previousElementSibling;
            } else if (e.key === 'ArrowRight') {
                targetButton = this.nextElementSibling;
            }
            
            if (targetButton && targetButton.classList.contains('confab-tabs-list-button')) {
                e.preventDefault();
                targetButton.click();
            }
        });
    });
});