const { __ } = wp.i18n;
const { InspectorControls } = wp.blockEditor;
const { PanelBody, SelectControl } = wp.components;
const { addFilter } = wp.hooks;

// Add visibility attributes to block settings.
const addVisibilityAttributes = (settings) => {
    if (typeof settings.attributes !== "undefined") {
        settings.attributes = {
            ...settings.attributes,
            visibility: {
                type: "object",
                default: {},
            },
        };
    }
    return settings;
};
addFilter(
    "blocks.registerBlockType",
    "conditional-block-visibility/add-attributes",
    addVisibilityAttributes
);

// Get dynamic user roles from localized data.
const dynamicUserRoles =
    window.conditionalBlockVisibilityData && window.conditionalBlockVisibilityData.roles
        ? window.conditionalBlockVisibilityData.roles
        : [];

// Prepend the "All Users" option to the dynamic roles.
const userRoleOptions = [
    { label: __("All Users", "conditional-block-visibility"), value: "" },
    ...dynamicUserRoles,
];

// Add the controls for visibility in Inspector Controls.
const addVisibilityControls = (BlockEdit) => (props) => {
    if (props.isSelected) {
        const { attributes, setAttributes } = props;
        const { visibility = {} } = attributes;

        return (
            <>
                <BlockEdit {...props} />
                <InspectorControls>
                    <PanelBody title={__("Visibility Settings", "conditional-block-visibility")}>
                        <SelectControl
                            label={__("User Role", "conditional-block-visibility")}
                            value={visibility.userRole}
                            options={userRoleOptions}
                            onChange={(userRole) =>
                                setAttributes({
                                    visibility: { ...visibility, userRole },
                                })
                            }
                        />
                        <SelectControl
                            label={__("Login Status", "conditional-block-visibility")}
                            value={visibility.loginStatus}
                            options={[
                                { label: __("Show to Everyone", "conditional-block-visibility"), value: "" },
                                { label: __("Logged In", "conditional-block-visibility"), value: "logged_in" },
                                { label: __("Logged Out", "conditional-block-visibility"), value: "logged_out" },
                            ]}
                            onChange={(loginStatus) =>
                                setAttributes({
                                    visibility: { ...visibility, loginStatus },
                                })
                            }
                        />
                        <SelectControl
                            label={__("Device Type", "conditional-block-visibility")}
                            value={visibility.deviceType}
                            options={[
                                { label: __("All Devices", "conditional-block-visibility"), value: "" },
                                { label: __("Desktop", "conditional-block-visibility"), value: "desktop" },
                                { label: __("Tablet", "conditional-block-visibility"), value: "tablet" },
                                { label: __("Mobile", "conditional-block-visibility"), value: "mobile" },
                            ]}
                            onChange={(deviceType) =>
                                setAttributes({
                                    visibility: { ...visibility, deviceType },
                                })
                            }
                        />
                    </PanelBody>
                </InspectorControls>
            </>
        );
    }
    return <BlockEdit {...props} />;
};
addFilter("editor.BlockEdit", "conditional-block-visibility/add-controls", addVisibilityControls);
