(function () {
    var __ = wp.i18n.__,
        InspectorControls = wp.blockEditor.InspectorControls,
        PanelBody = wp.components.PanelBody,
        SelectControl = wp.components.SelectControl,
        addFilter = wp.hooks.addFilter;

    function addVisibilityAttributes(settings) {
        if (typeof settings.attributes !== "undefined") {
            settings.attributes = Object.assign({}, settings.attributes, {
                visibility: {
                    type: "object",
                    default: {}
                }
            });
        }
        return settings;
    }
    addFilter("blocks.registerBlockType", "conditional-block-visibility/add-attributes", addVisibilityAttributes);

    var dynamicUserRoles =
        window.conditionalBlockVisibilityData &&
            window.conditionalBlockVisibilityData.roles
            ? window.conditionalBlockVisibilityData.roles
            : [];


    var userRoleOptions = [{
        label: __("All Users", "conditional-block-visibility"),
        value: ""
    }].concat(dynamicUserRoles);

    function addVisibilityControls(BlockEdit) {
        return function (props) {
            if (props.isSelected) {
                var attributes = props.attributes,
                    setAttributes = props.setAttributes;
                var visibility = attributes.visibility || {};

                return [
                    React.createElement(BlockEdit, Object.assign({}, props)),
                    React.createElement(
                        InspectorControls,
                        null,
                        React.createElement(
                            PanelBody,
                            { title: __("Visibility Settings", "conditional-block-visibility") },
                            React.createElement(SelectControl, {
                                label: __("User Role", "conditional-block-visibility"),
                                value: visibility.userRole,
                                options: userRoleOptions,
                                onChange: function (userRole) {
                                    return setAttributes({
                                        visibility: Object.assign({}, visibility, { userRole: userRole })
                                    });
                                }
                            }),
                            React.createElement(SelectControl, {
                                label: __("Login Status", "conditional-block-visibility"),
                                value: visibility.loginStatus,
                                options: [{
                                    label: __("Show to Everyone", "conditional-block-visibility"),
                                    value: ""
                                },
                                {
                                    label: __("Logged In", "conditional-block-visibility"),
                                    value: "logged_in"
                                },
                                {
                                    label: __("Logged Out", "conditional-block-visibility"),
                                    value: "logged_out"
                                }
                                ],
                                onChange: function (loginStatus) {
                                    return setAttributes({
                                        visibility: Object.assign({}, visibility, { loginStatus: loginStatus })
                                    });
                                }
                            }),
                            React.createElement(SelectControl, {
                                label: __("Device Type", "conditional-block-visibility"),
                                value: visibility.deviceType,
                                options: [{
                                    label: __("All Devices", "conditional-block-visibility"),
                                    value: ""
                                },
                                {
                                    label: __("Desktop", "conditional-block-visibility"),
                                    value: "desktop"
                                },
                                {
                                    label: __("Tablet", "conditional-block-visibility"),
                                    value: "tablet"
                                },
                                {
                                    label: __("Mobile", "conditional-block-visibility"),
                                    value: "mobile"
                                }
                                ],
                                onChange: function (deviceType) {
                                    return setAttributes({
                                        visibility: Object.assign({}, visibility, { deviceType: deviceType })
                                    });
                                }
                            })
                        )
                    )
                ];
            }
            return React.createElement(BlockEdit, props);
        };
    }
    addFilter("editor.BlockEdit", "conditional-block-visibility/add-controls", addVisibilityControls);
})();
