const defaultConfig                                = require( '@wordpress/scripts/config/webpack.config' );
const WooCommerceDependencyExtractionWebpackPlugin = require( '@woocommerce/dependency-extraction-webpack-plugin' );
const path = require( 'path' );

module.exports = {
	...defaultConfig,
	entry: {
		card: path.resolve( process.cwd(), 'assets/src', 'card.jsx' ),
		directdebit: path.resolve( process.cwd(), 'assets/src', 'directdebit.jsx' ),
		paypal: path.resolve( process.cwd(), 'assets/src', 'paypal.jsx' ),
		ideal: path.resolve( process.cwd(), 'assets/src', 'ideal.jsx' ),
		giropay: path.resolve( process.cwd(), 'assets/src', 'giropay.jsx' ),
		klarna: path.resolve( process.cwd(), 'assets/src', 'klarna.jsx' ),
		amazonpay: path.resolve( process.cwd(), 'assets/src', 'amazonpay.jsx' ),
		easycredit: path.resolve( process.cwd(), 'assets/src', 'easycredit.jsx' ),
	},
	output: {
		path: path.resolve( process.cwd(), 'assets/build' ),
		filename: '[name].js',
	},
	plugins: [
		...defaultConfig.plugins.filter(
			(plugin) =>
			plugin.constructor.name !== 'DependencyExtractionWebpackPlugin'
		),
		new WooCommerceDependencyExtractionWebpackPlugin(),
	],
};
