<?php

namespace ComputopPayments\Gateways\Blocks;

use ComputopPayments\Gateways\DirectDebit;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class DirectDebitBlock extends AbstractBlock {

	public const SHORT_CODE = 'directdebit';
	protected $name         = DirectDebit::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new DirectDebit();
		return array(
			'id'          => DirectDebit::GATEWAY_ID,
			'title'       => $gateway->title,
			'description' => $gateway->description,
			'nonce'       => wp_create_nonce( 'computop-direct-debit-nonce' ),
		);
	}
}
