<?php

namespace ComputopPayments\Gateways\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\Blocks\Utils\CartCheckoutUtils;
use ComputopPayments\Gateways\AmazonPay;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

abstract class AbstractBlock extends AbstractPaymentMethodType {

	public function get_name() {
		return $this->name;
	}

	public function is_active() {
		return true;
	}

	public function get_script_data() {
		return $this->get_payment_method_data();
	}

	public function get_payment_method_script_handles() {
		return array( 'computop-' . static::SHORT_CODE . '-block-checkout' );
	}


	public function initialize() {
		$this->settings = array(
			'title' => $this->get_setting( 'title' ),
		);

		$script_dependencies_path = COMPUTOP_PLUGIN_PATH . 'assets/build/' . static::SHORT_CODE . '.asset.php';
		$script_url               = COMPUTOP_PLUGIN_URL . '/assets/build/' . static::SHORT_CODE . '.js';
		$style_path               = COMPUTOP_PLUGIN_PATH . 'assets/build/' . static::SHORT_CODE . '.css';
		$style_url                = COMPUTOP_PLUGIN_URL . '/assets/build/' . static::SHORT_CODE . '.css';
		$asset_handle             = 'computop-' . static::SHORT_CODE . '-block-checkout';

		$script_dependencies = require $script_dependencies_path;
		wp_register_script( $asset_handle, $script_url, $script_dependencies['dependencies'], $script_dependencies['version'], array( 'in_footer' => true ) );
		if ( file_exists( $style_path ) ) {
			wp_register_style( $asset_handle, $style_url, array(), COMPUTOP_VERSION );
		}

		wp_set_script_translations( $asset_handle, 'computop-payments' );

		if ( $this->should_enqueue_assets() ) {
			wp_enqueue_script( $asset_handle );
			if ( wp_style_is( $asset_handle, 'registered' ) ) {
				wp_enqueue_style( $asset_handle );
			}
		}
	}

	private function should_enqueue_assets(): bool {
		$should_enqueue = ! is_order_received_page() && ! is_checkout_pay_page();

		$is_cart_block_in_use     = class_exists( CartCheckoutUtils::class ) && CartCheckoutUtils::is_cart_block_default();
		$is_checkout_block_in_use = class_exists( CartCheckoutUtils::class ) && CartCheckoutUtils::is_checkout_block_default();

		return $should_enqueue && ( wp_is_block_theme() || $is_cart_block_in_use || $is_checkout_block_in_use );
	}
}
