import { decodeEntities } from '@wordpress/html-entities'
import { __ } from '@wordpress/i18n'
import { registerPaymentMethod } from '@woocommerce/blocks-registry'
import { getSetting } from '@woocommerce/settings'

const settings = getSetting('computop_easycredit_data', {})
const gatewayTitle = settings?.title || __('EasyCredit', 'computop-payments')
const gatewayName = settings?.id || 'computop_easycredit'
const gatewayDescription = settings?.description || ''

const EasyCreditContent = () => {
    return (
        <div>
            {gatewayDescription && <p>{gatewayDescription}</p>}
        </div>
    )
}

registerPaymentMethod({
    name: gatewayName,
    label: (
        <div>
            <span className='wc-block-components-payment-method-label'>
                {gatewayTitle}
            </span>
        </div>
    ),
    content: <EasyCreditContent />,
    edit: <EasyCreditContent />,
    canMakePayment: () => true,
    ariaLabel: decodeEntities(gatewayTitle),
    supports: {
        features: settings?.supports || ['products'],
        showSavedCards: false,
        showSaveOption: false
    }
})
