import { decodeEntities } from '@wordpress/html-entities'
import { __ } from '@wordpress/i18n'
import { registerPaymentMethod } from '@woocommerce/blocks-registry'
import { getSetting } from '@woocommerce/settings'
import { useEffect, useState } from '@wordpress/element'

const settings = getSetting('computop_card_data', {})
const gatewayTitle = settings?.title || __('Credit Card', 'computop-payments')
const gatewayName = settings?.id || 'computop_card'
const gatewayDescription = settings?.description || ''
const browserInfoNonce = settings?.browserInfoNonce || ''

const CardContent = ({ eventRegistration, emitResponse }) => {
    const { onPaymentSetup } = eventRegistration;
    useEffect(() => {
        const unsubscribe = onPaymentSetup(() => {
            return {
                type: emitResponse?.responseTypes?.SUCCESS,
                meta: {
                    paymentMethodData: {
                        'cptbrowserinfoblocks': typeof computopGetBrowserInfo !== 'undefined' ? JSON.stringify(computopGetBrowserInfo()): ''
                    }
                }
            }
        });
        return unsubscribe
    }, [onPaymentSetup])


    return (
        <div>
            {gatewayDescription && <p>{gatewayDescription}</p>}
        </div>
    )
}

registerPaymentMethod({
    name: gatewayName,
    label: (
        <div>
            <span className='wc-block-components-payment-method-label'>
                {gatewayTitle}
            </span>
        </div>
    ),
    content: <CardContent />,
    edit: <CardContent />,
    canMakePayment: () => true,
    ariaLabel: decodeEntities(gatewayTitle),
    supports: {
        features: settings?.supports || ['products'],
        showSavedCards: false,
        showSaveOption: false
    }
})
