/**
 * Gets browser information for Computop payment processing.
 *
 * @returns {{javaScriptEnabled: boolean, javaEnabled: boolean, screenHeight: number, screenWidth: number, colorDepth: number, timeZoneOffset: number, language: string}}
 */
function computopGetBrowserInfo(){
	return {
		javaScriptEnabled: 'true',
		javaEnabled: 'false', // navigator.javaEnabled() is deprecated and always returns false
		screenHeight: screen.height,
		screenWidth: screen.width,
		colorDepth: screen.colorDepth,
		timeZoneOffset: (new Date()).getTimezoneOffset(),
		language: navigator.language
	};
}

setInterval(
	function () {
		const container = document.getElementById( 'cpt-browser-info-container' );
		if ( ! container) {
			return;
		}
		if (container.querySelector( '#cpt-browser-info-field-container' )) {
			return;
		}

		const data = computopGetBrowserInfo();

		const browserInfoFieldContainer         = document.createElement( 'div' );
		browserInfoFieldContainer.id            = 'cpt-browser-info-field-container';
		browserInfoFieldContainer.style.display = 'none';

		const inputFieldCreator = (name, value) => {
			const input         = document.createElement( 'input' );
			input.type          = 'hidden';
			input.name          = name;
			input.value         = value;
			return input;

		}
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[javaScriptEnabled]', data.javaScriptEnabled ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[javaEnabled]', data.javaEnabled ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[screenHeight]', data.screenHeight ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[screenWidth]', data.screenWidth ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[colorDepth]', data.colorDepth ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[timeZoneOffset]', data.timeZoneOffset ) );
		browserInfoFieldContainer.appendChild( inputFieldCreator( 'cptBrowserInfo[language]', data.language ) );

		container.appendChild( browserInfoFieldContainer );
	},
	300
);