<?php

namespace ComputopPayments\Gateways\Blocks;

use ComputopPayments\Gateways\Paypal;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class PaypalBlock extends AbstractBlock {
	public const SHORT_CODE = 'paypal';
	protected $name         = Paypal::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new Paypal();
		return array(
			'id'          => Paypal::GATEWAY_ID,
			'title'       => $gateway->title,
			'description' => $gateway->description,
		);
	}
}
