<?php

namespace ComputopPayments\Gateways\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\Blocks\Utils\CartCheckoutUtils;
use ComputopPayments\Gateways\Klarna;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class KlarnaBlock extends AbstractBlock {
	public const SHORT_CODE = 'klarna';
	protected $name         = Klarna::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new Klarna();
		return array(
			'id'          => Klarna::GATEWAY_ID,
			'title'       => $gateway->title,
			'description' => $gateway->description,
		);
	}
}
