<?php

namespace ComputopPayments\Gateways\Blocks;

use ComputopPayments\Gateways\Giropay;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GiropayBlock extends AbstractBlock {
	public const SHORT_CODE = 'giropay';
	protected $name         = Giropay::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new Giropay();
		return array(
			'id'          => Giropay::GATEWAY_ID,
			'title'       => $gateway->title,
			'description' => $gateway->description,
		);
	}
}
