<?php

namespace ComputopPayments\Gateways\Blocks;

use ComputopPayments\Gateways\Card;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CardBlock extends AbstractBlock {
	public const SHORT_CODE = 'card';
	protected $name         = Card::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new Card();
		return array(
			'id'               => Card::GATEWAY_ID,
			'title'            => $gateway->title,
			'description'      => $gateway->description,
			'browserInfoNonce' => wp_create_nonce( 'computop-browser-info-nonce' ),
		);
	}

	public function initialize() {
		parent::initialize();
		$gateway = new Card();
		#if ( $gateway->get_option( 'display_mode' ) === Card::DISPLAY_MODE_LOCAL ) {
			wp_enqueue_script( 'computop_browser_info', COMPUTOP_PLUGIN_URL . '/assets/js/browser_info.js' );
		#}
	}
}
