<?php

namespace ComputopPayments\Gateways\Blocks;

use ComputopPayments\Gateways\AmazonPay;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AmazonPayBlock extends AbstractBlock {

	public const SHORT_CODE = 'amazonpay';
	protected $name         = AmazonPay::GATEWAY_ID;

	public function get_payment_method_data() {
		$gateway = new AmazonPay();
		return array(
			'id'          => AmazonPay::GATEWAY_ID,
			'title'       => $gateway->title,
			'description' => $gateway->description,
		);
	}

	public function initialize() {
		parent::initialize();
		$gateway = new AmazonPay();
		$gateway->enqueue_scripts();
	}
}
