import { decodeEntities } from '@wordpress/html-entities'
import { __ } from '@wordpress/i18n'
import { registerPaymentMethod } from '@woocommerce/blocks-registry'
import { getSetting } from '@woocommerce/settings'

const settings = getSetting('computop_paypal_data', {})
console.log(settings);
const gatewayTitle = settings?.title || __('PayPal', 'computop-payments')
const gatewayName = settings?.id || 'computop_paypal'
const gatewayDescription = settings?.description || ''

const PaypalContent = () => {
    return (
        <div>
            {gatewayDescription && <p>{gatewayDescription}</p>}
        </div>
    )
}

registerPaymentMethod({
    name: gatewayName,
    label: (
        <div>
            <span className='wc-block-components-payment-method-label'>
                {gatewayTitle}
            </span>
        </div>
    ),
    content: <PaypalContent />,
    edit: <PaypalContent />,
    canMakePayment: () => true,
    ariaLabel: decodeEntities(gatewayTitle),
    supports: {
        features: settings?.supports || ['products'],
        showSavedCards: false,
        showSaveOption: false
    }
})
