import { decodeEntities } from '@wordpress/html-entities'
import { __ } from '@wordpress/i18n'
import { registerPaymentMethod } from '@woocommerce/blocks-registry'
import { getSetting } from '@woocommerce/settings'

const settings = getSetting('computop_giropay_data', {})
const gatewayTitle = settings?.title || __('Giropay', 'computop-payments')
const gatewayName = settings?.id || 'computop_giropay'
const gatewayDescription = settings?.description || ''

const GiropayContent = () => {
    return (
        <div>
            {gatewayDescription && <p>{gatewayDescription}</p>}
        </div>
    )
}

registerPaymentMethod({
    name: gatewayName,
    label: (
        <div>
            <span className='wc-block-components-payment-method-label'>
                {gatewayTitle}
            </span>
        </div>
    ),
    content: <GiropayContent />,
    edit: <GiropayContent />,
    canMakePayment: () => true,
    ariaLabel: decodeEntities(gatewayTitle),
    supports: {
        features: settings?.supports || ['products'],
        showSavedCards: false,
        showSaveOption: false
    }
})
