import { decodeEntities } from '@wordpress/html-entities'
import { __ } from '@wordpress/i18n'
import { registerPaymentMethod } from '@woocommerce/blocks-registry'
import { getSetting } from '@woocommerce/settings'
import { useEffect, useState } from '@wordpress/element'
import './directdebit.css'

const settings = getSetting('computop_directdebit_data', {})
const gatewayTitle = settings?.title || __('Direct Debit', 'computop-payments')
const gatewayName = settings?.id || 'computop_directdebit'
const gatewayDescription = settings?.description || ''
const nonce = settings?.nonce || ''


const DirectDebitContent = ({ eventRegistration, emitResponse }) => {
    const { onPaymentSetup } = eventRegistration;
    const [iban, setIban] = useState('');
    const [accountOwner, setAccountOwner] = useState('');

    useEffect(() => {
        const unsubscribe = onPaymentSetup(() => {
            return {
                type: emitResponse?.responseTypes?.SUCCESS,
                meta: {
                    paymentMethodData: {
                        'computop-direct-debit-iban': iban,
                        'computop-direct-debit-account-owner': accountOwner,
                        'computop-direct-debit-nonce': nonce
                    }
                }
            }
        });
        return unsubscribe
    }, [onPaymentSetup, iban, accountOwner])


    return (
        <div>
            {gatewayDescription && <p>{gatewayDescription}</p>}
            <div id="computop-direct-debit-form">
                <div className="computop-direct-debit-field">
                    <label htmlFor="computop-direct-debit-iban">
                        {__('IBAN', 'computop-payments')}
                    </label>
                    <input
                        type="text"
                        id="computop-direct-debit-iban"
                        name="computop-direct-debit-iban"
                        placeholder="DE12 3456 7890 1234 5678 90"
                        value={iban}
                        onChange={(e) => setIban(e.target.value)}
                    />
                </div>
                <div className="computop-direct-debit-field">
                    <label htmlFor="computop-direct-debit-account-owner">
                        {__('Account Owner', 'computop-payments')}
                    </label>
                    <input
                        type="text"
                        id="computop-direct-debit-account-owner"
                        name="computop-direct-debit-account-owner"
                        placeholder=""
                        value={accountOwner}
                        onChange={(e) => setAccountOwner(e.target.value)}
                    />
                </div>
            </div>
        </div>
    )
}

registerPaymentMethod({
    name: gatewayName,
    label: (
        <div>
            <span className='wc-block-components-payment-method-label'>
                {gatewayTitle}
            </span>
        </div>
    ),
    content: <DirectDebitContent/>,
    edit: <DirectDebitContent/>,
    canMakePayment: () => true,
    ariaLabel: decodeEntities(gatewayTitle),
    supports: {
        features: settings?.supports || ['products'],
        showSavedCards: false,
        showSaveOption: false
    }
})
