/**
 * Initializes and renders the Amazon Pay button with checkout session configuration.
 *
 * @param {Object} paymentData - Amazon Pay payment configuration data
 * @param {string} paymentData.apButtonPayload - JSON payload for Amazon Pay checkout session
 * @param {string} paymentData.apButtonSignature - Signature for Amazon Pay button authentication
 * @param {string} paymentData.apButtonPublicKeyId - Public key ID for Amazon Pay button verification
 */
function computopStartAmazonPay(paymentData){
	const amazonPayCptButton = amazon.Pay.renderButton(
		'#cpt-amazon-pay-button',
		{
			merchantId: window.cpt_amazonPay.merchantId,
			sandbox: window.cpt_amazonPay.sandbox === 'yes',
			ledgerCurrency: window.cpt_amazonPay.ledgerCurrency,
			checkoutLanguage: window.cpt_amazonPay.checkoutLanguage,
			productType: 'PayAndShip',
			placement: 'Cart',
			buttonColor: 'Gold'
		}
	);

	amazonPayCptButton.initCheckout(
		{
			createCheckoutSessionConfig: {
				payloadJSON: paymentData.apButtonPayload,
				signature: paymentData.apButtonSignature,
				publicKeyId: paymentData.apButtonPublicKeyId
			}
		}
	);
}
jQuery(
	function () {
		jQuery( 'form.woocommerce-checkout' ).on(
			'checkout_place_order_success',
			function (e, data) {

				if (data.method && data.method === 'cptAmazonPay' && data.paymentData) {

				}

			}
		);
	}
)