<?php
/**
 * Cache Manager Class file.
 *
 * @package Color_Theme_Manager_For_Divi
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Handles the clearing of Divi theme specific caches.
 *
 * @since 1.0.0
 */
class CTMD_Cache_Manager {

	/**
	 * Clears all relevant Divi caches.
	 *
	 * Clears the core Divi cache, the builder cache, and removes
	 * static CSS resources to ensure style changes are reflected immediately.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function clear_divi_cache() {
		// Core Divi cache.
		if ( function_exists( 'et_core_clear_cache' ) ) {
			et_core_clear_cache();
		}
		// Builder cache.
		if ( function_exists( 'et_builder_clear_cache' ) ) {
			et_builder_clear_cache();
		}
		// Static CSS file cache.
		if ( class_exists( 'ET_Core_PageResource' ) ) {
			ET_Core_PageResource::remove_static_resources( 'all', 'all' );
		}
		delete_option( 'et_pb_static_css_cache' );
	}
}
