<?php

/**
 * Plugin Name:       Color Theme Manager for Divi
 * Plugin URI:        https://divinous.com
 * Description:       The ultimate manager for Divi Colors. Create accessible Divi Color Palettes, generate Divi Dark Mode themes, and fix WCAG contrast issues.
 * Version:           1.3.10
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       color-theme-manager-for-divi
 * Requires at least: 6.6
 * Requires PHP:      7.4
 *
 *
 * @package Color_Theme_Manager_For_Divi
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
if ( function_exists( 'ctmd_fs' ) ) {
    ctmd_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'ctmd_fs' ) ) {
        /** Create a helper function for easy SDK access. **/
        function ctmd_fs() {
            global $ctmd_fs;
            if ( !isset( $ctmd_fs ) ) {
                // Include Freemius SDK.
                require_once __DIR__ . '/vendor/freemius/start.php';
                $ctmd_fs = fs_dynamic_init( array(
                    'id'               => '20639',
                    'slug'             => 'color-theme-manager-for-divi',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_d9189c0efd672287ec1e551ea597d',
                    'is_premium'       => false,
                    'is_premium_only'  => false,
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'is_org_compliant' => true,
                    'menu'             => array(
                        'slug'    => 'color-theme-manager-for-divi',
                        'contact' => false,
                        'support' => false,
                    ),
                    'is_live'          => true,
                ) );
            }
            return $ctmd_fs;
        }

        // Init Freemius.
        ctmd_fs();
        // Signal that SDK was initiated.
        do_action( 'ctmd_fs_loaded' );
    }
    // Define Constants.
    define( 'CTMD_VERSION', '1.3.10' );
    define( 'CTMD_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
    define( 'CTMD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
    define( 'CTMD_COLOR_ORDER_START_INDEX', 4 );
    // Include class files.
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-utilities.php';
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-cache-manager.php';
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-color-manager.php';
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-palette-manager.php';
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-admin.php';
    require_once CTMD_PLUGIN_DIR . 'includes/class-ctmd-main.php';
    /**
     * Begins execution of the plugin.
     */
    function ctmd_run_plugin() {
        $plugin = new CTMD_Main();
    }

    ctmd_run_plugin();
    /** Freemius: Set default currency for WP Admin pricing page **/
    function ctmd_default_currency(  $currency  ) {
        return 'eur';
    }

    ctmd_fs()->add_filter( 'default_currency', 'ctmd_default_currency' );
    /** Freemius: Show annual prices in pricing tables */
    ctmd_fs()->add_filter( 'pricing/show_annual_in_monthly', '__return_false' );
    /**
     * Checks if the bundled JSON file has been updated by comparing its hash.
     * If it has, it updates the master layout in the database.
     */
    function ctmd_check_json_update() {
        // If the user has uploaded a custom layout, do not overwrite it.
        if ( get_option( 'ctmd_master_layout_is_custom' ) ) {
            return;
        }
        return;
    }

    add_action( 'admin_init', 'ctmd_check_json_update' );
    /**
     * The code that runs during plugin activation.
     */
    function ctmd_activate() {
        $required_version = '5.0.0-public-alpha.20';
        $current_theme = wp_get_theme();
        $divi_version = get_option( 'et_core_version' );
        if ( 'Divi' !== $current_theme->get( 'Name' ) && 'Divi' !== $current_theme->get( 'Template' ) ) {
            deactivate_plugins( plugin_basename( __FILE__ ) );
            wp_die( esc_html__( 'This plugin requires the Divi theme to be active.', 'color-theme-manager-for-divi' ) );
        }
        if ( version_compare( $divi_version, $required_version, '<' ) ) {
            deactivate_plugins( plugin_basename( __FILE__ ) );
            wp_die( sprintf( 
                /* translators: %s: Required Divi version number. */
                esc_html__( 'Color Theme Manager for Divi requires Divi version %s or greater.', 'color-theme-manager-for-divi' ),
                esc_html( $required_version )
             ) );
        }
    }

    register_activation_hook( __FILE__, 'ctmd_activate' );
    // Hook into Freemius's uninstall process.
    ctmd_fs()->add_action( 'after_uninstall', array('CTMD_Main', 'uninstall') );
}