<?php
/**
 * View: Theme Generator Tab
 *
 * Provides the interface for uploading a JSON file (e.g., from websitestylekit.com),
 * staging the data, previewing the colors, and generating the Light/Dark/Mixed palettes.
 *
 * @package Color_Theme_Manager_For_Divi
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// The $this variable is an instance of CTMD_Admin.
?>
<div id="ctmd-theme-generator">
	<h3><?php esc_html_e( 'Generate Theme Palettes', 'color-theme-manager-for-divi' ); ?></h3>

	<?php
	// WPCS Fix: Προσθήκη prefix 'ctmd_'.
	$ctmd_staged_data = get_transient( 'ctmd_staged_theme' );

	if ( $ctmd_staged_data && ! empty( $ctmd_staged_data['json'] ) ) :
		// WPCS Fix: Προσθήκη prefix 'ctmd_'.
		$ctmd_colors = json_decode( $ctmd_staged_data['json'], true );
		?>
		<?php if ( ! empty( $ctmd_staged_data['name'] ) ) : ?>
			<div class="ctmd-staged-theme-info">
				<strong><?php esc_html_e( 'Staged Theme Name:', 'color-theme-manager-for-divi' ); ?></strong>
				<span><?php echo esc_html( $ctmd_staged_data['name'] ); ?></span>
			</div>
		<?php endif; ?>

		<p><?php esc_html_e( 'The following colors were found in the uploaded file. If they are correct, you can proceed to generate the theme palettes.', 'color-theme-manager-for-divi' ); ?></p>

		<table class="wp-list-table widefat fixed striped">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Color Name', 'color-theme-manager-for-divi' ); ?></th>
					<th><?php esc_html_e( 'Hex Value', 'color-theme-manager-for-divi' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $ctmd_colors as $ctmd_color ) : ?>
					<tr>
						<td><?php echo esc_html( $ctmd_color['name'] ); ?></td>
						<td>
							<span class="ctmd-color-swatch" data-color="<?php echo esc_attr( $ctmd_color['hex'] ); ?>"></span>
							<code><?php echo esc_html( $ctmd_color['hex'] ); ?></code>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<div class="ctmd-generator-actions">
			<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
				<input type="hidden" name="action" value="ctmd_generate_from_staged">
				<?php wp_nonce_field( 'ctmd_generate_from_staged_nonce' ); ?>
				<?php submit_button( esc_html__( 'Generate Theme Palettes', 'color-theme-manager-for-divi' ), 'primary', 'generate_palettes', false ); ?>
			</form>
			<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
				<input type="hidden" name="action" value="ctmd_clear_staged_json">
				<?php wp_nonce_field( 'ctmd_clear_staged_json_nonce' ); ?>
				<?php submit_button( esc_html__( 'Clear / Upload New File', 'color-theme-manager-for-divi' ), 'secondary', 'clear_staged', false ); ?>
			</form>
		</div>

	<?php else : ?>
		<p>
			<?php
			printf(
				wp_kses(
					/* translators: %s: URL for websitestylekit.com */
					__( 'Go to <a href="%s" target="_blank" rel="noopener noreferrer">websitestylekit.com (v2.0)</a> and copy the JSON code from the <strong>"Primary Palette"</strong> tab. Save this as a .json file on your computer. Then, upload that file here. The plugin will automatically read the colors from your file to generate the Light, Dark, and Mixed theme palettes.', 'color-theme-manager-for-divi' ),
					array(
						'a'      => array(
							'href'   => array(),
							'target' => array(),
							'rel'    => array(),
						),
						'strong' => array(),
					)
				),
				'https://websitestylekit.com/'
			);
			?>
		</p>
		<form method="post" enctype="multipart/form-data" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
			<input type="hidden" name="action" value="ctmd_stage_json_file">
			<?php wp_nonce_field( 'ctmd_stage_json_nonce' ); ?>

			<p>
				<label for="ctmd-theme-name"><?php esc_html_e( 'Theme Name', 'color-theme-manager-for-divi' ); ?></label><br>
				<input type="text" id="ctmd-theme-name" name="ctmd_theme_name" class="regular-text" placeholder="<?php esc_attr_e( 'e.g. My Client\'s Theme', 'color-theme-manager-for-divi' ); ?>" required>
			</p>

			<p>
				<label for="ctmd-json-file"><?php esc_html_e( 'Select JSON File', 'color-theme-manager-for-divi' ); ?></label><br>
				<input type="file" id="ctmd-json-file" name="ctmd_json_file" accept=".json" required>
			</p>

			<?php submit_button( __( 'Upload and Preview', 'color-theme-manager-for-divi' ), 'secondary', 'upload_and_preview' ); ?>
		</form>
	<?php endif; ?>
</div>
