<?php

/**
 * View: Settings Page
 *
 * Displays general plugin settings including import/export options, master layout download,
 * color reset functionality, and uninstallation behavior configuration.
 *
 * @package Color_Theme_Manager_For_Divi
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
// The $this variable is an instance of CTMD_Admin.
?>
<div id="ctmd-settings-manager">
	<?php 
?>
		<div class="ctmd-premium-feature-notice">
			<h2><?php 
esc_html_e( 'Import / Export & Master Divi Layout are Premium Features', 'color-theme-manager-for-divi' );
?></h2>
			<p><?php 
esc_html_e( 'Upgrade to the premium version to unlock these features and many more!', 'color-theme-manager-for-divi' );
?></p>
			<a href="<?php 
echo esc_url( ctmd_fs()->get_upgrade_url() );
?>" class="button button-primary"><?php 
esc_html_e( 'Upgrade Now', 'color-theme-manager-for-divi' );
?></a>
		</div>
	<?php 
?>
	<div class="
	<?php 
echo 'ctmd-disabled-section';
?>
	">
	<h3><?php 
esc_html_e( 'Import / Export', 'color-theme-manager-for-divi' );
?>
	<?php 
?>
		<span class="ctmd-premium-badge">Premium</span><?php 
?></h3>
	<p><?php 
esc_html_e( 'Export your color and palette settings to a file, or import them on another site.', 'color-theme-manager-for-divi' );
?></p>
	<form method="post" action="<?php 
echo esc_url( admin_url( 'admin-post.php' ) );
?>">
		<input type="hidden" name="action" value="ctmd_export_settings">
		<?php 
wp_nonce_field( 'ctmd_export_nonce' );
?>
		<?php 
submit_button(
    __( 'Export Settings', 'color-theme-manager-for-divi' ),
    'secondary',
    'export',
    false
);
?>
	</form>
	<hr>
	<form method="post" enctype="multipart/form-data" action="<?php 
echo esc_url( admin_url( 'admin-post.php' ) );
?>">
		<input type="hidden" name="action" value="ctmd_import_settings">
		<?php 
wp_nonce_field( 'ctmd_import_nonce' );
?>
		<label for="ctmd-import-file"><?php 
esc_html_e( 'Import Settings File', 'color-theme-manager-for-divi' );
?></label><br>
		<input type="file" id="ctmd-import-file" name="ctmd_import_file" accept=".json" required>
		<?php 
submit_button(
    __( 'Import Settings', 'color-theme-manager-for-divi' ),
    'primary',
    'import',
    false
);
?>
	</form>
	</div>
	<hr class="hr-30">

	<div class="
	<?php 
echo 'ctmd-disabled-section';
?>
	">
	<h3>
		<?php 
esc_html_e( 'Master Divi Layout', 'color-theme-manager-for-divi' );
?>
		<?php 
?>
			<span class="ctmd-premium-badge">Premium</span><?php 
?>
		<?php 
if ( defined( 'CTMD_DEV_MODE' ) && CTMD_DEV_MODE ) {
    ?>
			<span>(Dev Mode)</span>
		<?php 
}
?>
	</h3>

	<p><?php 
esc_html_e( 'Download a pre-made Divi layout file that is pre-configured to work with this plugin\'s color system.', 'color-theme-manager-for-divi' );
?></p>
	<form class="form-inline" method="post" action="<?php 
echo esc_url( admin_url( 'admin-post.php' ) );
?>">
		<input type="hidden" name="action" value="ctmd_download_divi_layout">
		<?php 
wp_nonce_field( 'ctmd_download_divi_layout_nonce' );
?>
		<?php 
submit_button(
    __( 'Download Master Layout', 'color-theme-manager-for-divi' ),
    'secondary',
    'download_layout',
    false
);
?>
	</form>

	<?php 
?>
	</div>
	<hr class="hr-30">

	<h3><?php 
esc_html_e( 'Reset Colors', 'color-theme-manager-for-divi' );
?></h3>
	<p><?php 
esc_html_e( 'This will delete all custom global colors. This action cannot be undone.', 'color-theme-manager-for-divi' );
?></p>
	<form method="post" action="<?php 
echo esc_url( admin_url( 'admin-post.php' ) );
?>">
		<input type="hidden" name="action" value="ctmd_reset_colors">
		<?php 
wp_nonce_field( 'ctmd_reset_nonce' );
?>
		<p>
			<label>
				<input type="checkbox" name="reset_default_colors" value="1">
				<?php 
esc_html_e( 'Also reset the 4 default Divi colors (Primary, Secondary, etc.) to their original values.', 'color-theme-manager-for-divi' );
?>
			</label>
		</p>
		<p>
			<label>
				<input type="checkbox" name="delete_all_palettes" value="1">
				<?php 
esc_html_e( 'Also delete all saved palettes.', 'color-theme-manager-for-divi' );
?>
			</label>
		</p>
		<?php 
// WPCS Fix: Προσθήκη prefix 'ctmd_'.
$ctmd_reset_message = esc_js( __( 'Are you sure you want to delete all custom colors? This action cannot be undone.', 'color-theme-manager-for-divi' ) );
$ctmd_reset_message .= '\\n\\n' . esc_js( __( 'IMPORTANT: If a deleted color is in use on any page or post, the reference will NOT be updated automatically. You will need to update it manually.', 'color-theme-manager-for-divi' ) );
submit_button(
    __( 'Reset All Custom Colors', 'color-theme-manager-for-divi' ),
    'delete',
    'reset_colors',
    false,
    array(
        'onclick' => 'return confirm("' . $ctmd_reset_message . '");',
    )
);
?>
	</form>

	<hr class="hr-30">

	<h3><?php 
esc_html_e( 'Plugin Uninstallation', 'color-theme-manager-for-divi' );
?></h3>
	<form method="post" action="<?php 
echo esc_url( admin_url( 'admin-post.php' ) );
?>">
		<input type="hidden" name="action" value="ctmd_save_plugin_settings">
		<?php 
wp_nonce_field( 'ctmd_plugin_settings_nonce' );
?>
		<p>
			<label>
				<input type="checkbox" name="delete_on_uninstall" value="1"
				<?php 
$ctmd_settings = get_option( 'ctmd_settings', array() );
checked( ( isset( $ctmd_settings['delete_on_uninstall'] ) ? $ctmd_settings['delete_on_uninstall'] : 0 ), 1 );
?>
				>
				<?php 
esc_html_e( 'Delete all plugin data upon uninstallation. This includes all palettes and will reset all Divi colors.', 'color-theme-manager-for-divi' );
?>
			</label>
		</p>
		<?php 
submit_button( __( 'Save Uninstallation Setting', 'color-theme-manager-for-divi' ), 'primary', 'save_uninstall_setting' );
?>
	</form>
</div>
