<?php

/**
 * View: Palette Manager
 *
 * Displays saved theme groups and standalone palettes, allowing the user
 * to activate, restore, delete, or check contrast on them.
 *
 * @package Color_Theme_Manager_For_Divi
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
// The $this variable is an instance of CTMD_Admin.
// WPCS Fix: Προσθήκη prefix 'ctmd_' σε όλες τις τοπικές μεταβλητές.
$ctmd_themes = $this->palette_manager->get_themes();
$ctmd_palettes = $this->palette_manager->get_palettes();
$ctmd_settings = get_option( 'ctmd_settings', array() );
$ctmd_active_theme_name = $ctmd_settings['active_theme_name'] ?? null;
?>
<div id="ctmd-palettes-manager">
	<?php 
?>
		<div class="ctmd-premium-feature-notice">
			<h2><?php 
esc_html_e( 'Theme Groups are a Premium Feature', 'color-theme-manager-for-divi' );
?></h2>
			<p><?php 
esc_html_e( 'Upgrade to the premium version to unlock this feature and many more!', 'color-theme-manager-for-divi' );
?></p>
			<a href="<?php 
echo esc_url( ctmd_fs()->get_upgrade_url() );
?>" class="button button-primary"><?php 
esc_html_e( 'Upgrade Now', 'color-theme-manager-for-divi' );
?></a>
		</div>
	<?php 
?>
	<div class="ctmd-palettes-manager-container
	<?php 
echo 'ctmd-disabled-section';
?>
	">
	<h2><?php 
esc_html_e( 'Theme Groups', 'color-theme-manager-for-divi' );
?>
	<?php 
?>
		<span class="ctmd-premium-badge">Premium</span><?php 
?></h2>
	<p><?php 
esc_html_e( 'Activate a theme to apply its palettes (Light, Dark, Mixed) to your site\'s frontend via a mode switcher.', 'color-theme-manager-for-divi' );
?></p>

	<?php 
if ( empty( $ctmd_themes ) ) {
    ?>
		<p><?php 
    esc_html_e( 'No theme groups found. You can create one from the "Theme Generator" tab.', 'color-theme-manager-for-divi' );
    ?></p>
	<?php 
} else {
    ?>
		<?php 
    foreach ( $ctmd_themes as $ctmd_theme_group_name => $ctmd_theme_group_data ) {
        ?>
			<div class="ctmd-theme-group-container <?php 
        echo ( $ctmd_active_theme_name === $ctmd_theme_group_name ? 'active' : '' );
        ?>">
				<div class="ctmd-theme-group-header">
					<div class="ctmd-theme-group-title-swatches">
						<h3><?php 
        echo esc_html( $ctmd_theme_group_name );
        ?></h3>
						<?php 
        if ( $ctmd_active_theme_name === $ctmd_theme_group_name ) {
            ?>
							<span class="ctmd-active-theme-indicator"><?php 
            esc_html_e( 'Active', 'color-theme-manager-for-divi' );
            ?></span>
						<?php 
        }
        ?>
						<?php 
        if ( !empty( $ctmd_theme_group_data['source_colors'] ) ) {
            ?>
							<div class="ctmd-source-swatches">
								<?php 
            foreach ( $ctmd_theme_group_data['source_colors'] as $ctmd_color ) {
                ?>
									<span title="<?php 
                echo esc_attr( $ctmd_color );
                ?>" data-color="<?php 
                echo esc_attr( $ctmd_color );
                ?>"></span>
								<?php 
            }
            ?>
							</div>
						<?php 
        }
        ?>
					</div>
					<div class="ctmd-theme-group-actions">
						<?php 
        if ( $ctmd_active_theme_name === $ctmd_theme_group_name ) {
            ?>
							<form method="post" action="<?php 
            echo esc_url( admin_url( 'admin-post.php' ) );
            ?>">
								<input type="hidden" name="action" value="ctmd_deactivate_theme">
								<?php 
            wp_nonce_field( 'ctmd_deactivate_theme_nonce' );
            ?>
								<?php 
            submit_button(
                esc_html__( 'Deactivate', 'color-theme-manager-for-divi' ),
                'secondary',
                'deactivate_theme',
                false
            );
            ?>
							</form>
						<?php 
        } else {
            ?>
							<form method="post" action="<?php 
            echo esc_url( admin_url( 'admin-post.php' ) );
            ?>">
								<input type="hidden" name="action" value="ctmd_activate_theme">
								<input type="hidden" name="theme_group_name" value="<?php 
            echo esc_attr( $ctmd_theme_group_name );
            ?>">
								<?php 
            wp_nonce_field( 'ctmd_activate_theme_nonce' );
            ?>
								<?php 
            submit_button(
                esc_html__( 'Activate', 'color-theme-manager-for-divi' ),
                'primary',
                'activate_theme',
                false
            );
            ?>
							</form>
							<button
								class="button button-secondary ctmd-manual-contrast-check-btn"
								data-nonce="<?php 
            echo esc_attr( wp_create_nonce( 'ctmd_manual_contrast_check_nonce' ) );
            ?>"
								data-theme-group-name="<?php 
            echo esc_attr( $ctmd_theme_group_name );
            ?>"
							>
								<?php 
            esc_html_e( 'Run Contrast Check', 'color-theme-manager-for-divi' );
            ?>
							</button>
						<?php 
        }
        ?>

						<form method="post" action="<?php 
        echo esc_url( admin_url( 'admin-post.php' ) );
        ?>">
							<input type="hidden" name="action" value="ctmd_delete_theme_group">
							<input type="hidden" name="theme_group_name" value="<?php 
        echo esc_attr( $ctmd_theme_group_name );
        ?>">
							<?php 
        wp_nonce_field( 'ctmd_delete_theme_group_nonce' );
        ?>
							<?php 
        $ctmd_delete_button_args = array();
        if ( $ctmd_active_theme_name === $ctmd_theme_group_name ) {
            $ctmd_delete_button_args = array(
                'disabled' => 'disabled',
                'title'    => esc_attr__( 'You cannot delete an active theme. Please deactivate it first.', 'color-theme-manager-for-divi' ),
            );
        }
        submit_button(
            esc_html__( 'Delete Theme', 'color-theme-manager-for-divi' ),
            'delete',
            'delete_theme_group',
            false,
            $ctmd_delete_button_args
        );
        ?>
						</form>
					</div>
				</div>

				<?php 
        $ctmd_has_any_contrast_issues = false;
        if ( !empty( $ctmd_theme_group_data['palettes'] ) ) {
            foreach ( $ctmd_theme_group_data['palettes'] as $ctmd_palette ) {
                if ( !empty( $ctmd_palette['contrast_results'] ) ) {
                    $ctmd_has_any_contrast_issues = true;
                    break;
                }
            }
        }
        if ( $ctmd_has_any_contrast_issues ) {
            ?>
					<div class="notice notice-warning inline">
						<p>
							<strong><?php 
            esc_html_e( 'Contrast Warning:', 'color-theme-manager-for-divi' );
            ?></strong>
							<?php 
            esc_html_e( 'One or more palettes in this theme group have color combinations that may be difficult to read. Look for the ', 'color-theme-manager-for-divi' );
            ?><strong><span class="dashicons dashicons-warning"></span></strong><?php 
            esc_html_e( ' icon below to fix them.', 'color-theme-manager-for-divi' );
            ?>
						</p>
					</div>
				<?php 
        }
        ?>

				<div class="ctmd-accordion">
					<?php 
        foreach ( $ctmd_theme_group_data['palettes'] as $ctmd_palette_name => $ctmd_palette_data ) {
            ?>
						<div class="ctmd-accordion-item">
							<?php 
            $ctmd_has_contrast_issues = !empty( $ctmd_palette_data['contrast_results'] );
            ?>
							<h4 class="ctmd-accordion-header" data-has-issues="<?php 
            echo ( $ctmd_has_contrast_issues ? 'true' : 'false' );
            ?>">
								<span class="ctmd-accordion-icon">+</span>
								<?php 
            if ( $ctmd_has_contrast_issues ) {
                ?>
									<span class="dashicons dashicons-warning" title="<?php 
                esc_attr_e( 'This palette has contrast issues.', 'color-theme-manager-for-divi' );
                ?>"></span>
								<?php 
            }
            ?>
								<?php 
            echo esc_html( $ctmd_palette_name );
            ?>
							</h4>
							<div class="ctmd-accordion-content">
								<div class="ctmd-palette-actions">
									<form method="post" action="<?php 
            echo esc_url( admin_url( 'admin-post.php' ) );
            ?>">
										<input type="hidden" name="action" value="ctmd_restore_palette">
										<input type="hidden" name="theme_group_name" value="<?php 
            echo esc_attr( $ctmd_theme_group_name );
            ?>">
										<input type="hidden" name="sub_palette_name" value="<?php 
            echo esc_attr( $ctmd_palette_name );
            ?>">
										<?php 
            wp_nonce_field( 'ctmd_restore_nonce' );
            ?>
										<?php 
            $ctmd_confirm_message = esc_js( __( 'Are you sure you want to restore colors from this palette? This will overwrite your current color configuration.', 'color-theme-manager-for-divi' ) );
            $ctmd_confirm_message .= '\\n\\n' . esc_js( __( 'IMPORTANT: If this action deletes a color that is currently in use, the reference will NOT be updated automatically. You will need to update it manually.', 'color-theme-manager-for-divi' ) );
            submit_button(
                esc_html__( 'Restore Colors from this Palette', 'color-theme-manager-for-divi' ),
                'primary',
                'restore_palette',
                false,
                array(
                    'onclick' => 'return confirm("' . $ctmd_confirm_message . '");',
                )
            );
            ?>
									</form>
								</div>
								<table class="wp-list-table widefat fixed striped">
									<thead>
										<tr>
											<th class="col-label"><?php 
            esc_html_e( 'Label', 'color-theme-manager-for-divi' );
            ?></th>
											<th class="col-id"><?php 
            esc_html_e( 'ID', 'color-theme-manager-for-divi' );
            ?></th>
											<th class="col-hex"><?php 
            esc_html_e( 'HEX', 'color-theme-manager-for-divi' );
            ?></th>
											<th class="col-linked"><?php 
            esc_html_e( 'Linked Color', 'color-theme-manager-for-divi' );
            ?></th>
											<th class="col-hsl"><?php 
            esc_html_e( 'HSL', 'color-theme-manager-for-divi' );
            ?></th>
											<th class="col-rgb"><?php 
            esc_html_e( 'RGB', 'color-theme-manager-for-divi' );
            ?></th>
										</tr>
									</thead>
									<tbody>
										<?php 
            // Build a complete color map for the resolver.
            $ctmd_resolver_map = array();
            if ( !empty( $ctmd_palette_data['global_colors'] ) ) {
                $ctmd_resolver_map = $ctmd_palette_data['global_colors'];
            }
            if ( !empty( $ctmd_palette_data['special_colors'] ) ) {
                foreach ( $ctmd_palette_data['special_colors'] as $ctmd_id => $ctmd_color ) {
                    $ctmd_display_id = $this->special_color_display_ids[$ctmd_id] ?? $ctmd_id;
                    $ctmd_resolver_map[$ctmd_display_id] = array(
                        'label' => $this->special_colors_map[$ctmd_id] ?? $ctmd_id,
                        'color' => $ctmd_color,
                    );
                }
            }
            // Prepare the final list of colors to display in order.
            $ctmd_display_colors = array();
            if ( !empty( $ctmd_palette_data['special_colors'] ) ) {
                foreach ( $ctmd_palette_data['special_colors'] as $ctmd_id => $ctmd_color ) {
                    $ctmd_display_id = $this->special_color_display_ids[$ctmd_id] ?? $ctmd_id;
                    $ctmd_display_colors[$ctmd_display_id] = array(
                        'label'  => $this->special_colors_map[$ctmd_id] ?? $ctmd_id,
                        'color'  => $ctmd_color,
                        'status' => 'active',
                    );
                }
            }
            if ( !empty( $ctmd_palette_data['global_colors'] ) ) {
                foreach ( $ctmd_palette_data['global_colors'] as $ctmd_id => $ctmd_color_data ) {
                    $ctmd_display_colors[$ctmd_id] = $ctmd_color_data;
                }
            }
            foreach ( $ctmd_display_colors as $ctmd_id => $ctmd_data ) {
                $ctmd_resolved_color = CTMD_Utilities::resolve_color( $ctmd_data['color'], $ctmd_resolver_map );
                $ctmd_is_derivative = strpos( $ctmd_data['color'], '$variable' ) === 0;
                $ctmd_parent_name = ( $ctmd_is_derivative ? CTMD_Utilities::get_parent_name( $ctmd_data['color'], $ctmd_resolver_map ) : '' );
                ?>
										<tr>
											<td>
												<?php 
                $ctmd_contrast_issue = $ctmd_palette_data['contrast_results'][$ctmd_id] ?? null;
                $ctmd_is_theme_active = $ctmd_active_theme_name === $ctmd_theme_group_name;
                if ( $ctmd_contrast_issue ) {
                    $ctmd_ratio_display = number_format( $ctmd_contrast_issue['contrast'], 2 );
                    $ctmd_text_label = $ctmd_contrast_issue['text_label'] ?? 'N/A';
                    $ctmd_bg_label = $ctmd_contrast_issue['bg_label'] ?? 'N/A';
                    if ( $ctmd_is_theme_active ) {
                        $ctmd_tooltip = sprintf(
                            /* translators: 1: Text color label, 2: Background color label, 3: Contrast ratio. */
                            __( 'Low contrast between \'%1$s\' and \'%2$s\'. Ratio: %3$s. Deactivate the theme to enable the fix button.', 'color-theme-manager-for-divi' ),
                            $ctmd_text_label,
                            $ctmd_bg_label,
                            $ctmd_ratio_display
                        );
                        ?>
														<span class="dashicons dashicons-warning ctmd-contrast-warning-icon" title="<?php 
                        echo esc_attr( $ctmd_tooltip );
                        ?>"></span>
														<span class="ctmd-contrast-ratio"><?php 
                        echo esc_html( $ctmd_ratio_display );
                        ?></span>
														<?php 
                    } else {
                        $ctmd_tooltip = sprintf(
                            /* translators: 1: Text color label, 2: Background color label, 3: Contrast ratio. */
                            __( 'Low contrast between \'%1$s\' and \'%2$s\'. Ratio: %3$s. Click to fix.', 'color-theme-manager-for-divi' ),
                            $ctmd_text_label,
                            $ctmd_bg_label,
                            $ctmd_ratio_display
                        );
                        ?>
														<button
															class="ctmd-fix-contrast-btn"
															title="<?php 
                        echo esc_attr( $ctmd_tooltip );
                        ?>"
															data-nonce="<?php 
                        echo esc_attr( wp_create_nonce( 'ctmd_fix_contrast_nonce' ) );
                        ?>"
															data-theme-group-name="<?php 
                        echo esc_attr( $ctmd_theme_group_name );
                        ?>"
															data-sub-palette-name="<?php 
                        echo esc_attr( $ctmd_palette_name );
                        ?>"
															data-color-id="<?php 
                        echo esc_attr( $ctmd_id );
                        ?>"
														>
															<span class="dashicons dashicons-warning"></span>
															<span class="ctmd-contrast-ratio"><?php 
                        echo esc_html( $ctmd_ratio_display );
                        ?></span>
														</button>
														<?php 
                    }
                }
                ?>
												<?php 
                echo esc_html( $ctmd_data['label'] );
                ?>
											</td>
											<td><code><?php 
                echo esc_html( $ctmd_id );
                ?></code></td>
											<td data-color-id="<?php 
                echo esc_attr( $ctmd_id );
                ?>">
												<span class="ctmd-color-swatch" data-color="<?php 
                echo esc_attr( $ctmd_resolved_color );
                ?>"></span>
												<span class="hex-value ctmd-copy-me"><?php 
                echo esc_html( CTMD_Utilities::normalize_to_hex( $ctmd_resolved_color ) );
                ?></span>
											</td>
											<td><?php 
                echo esc_html( $ctmd_parent_name );
                ?></td>
											<td><small class="hsl-value ctmd-copy-me"><?php 
                echo esc_html( CTMD_Utilities::hex_to_hsl( $ctmd_resolved_color ) );
                ?></small></td>
											<td><small class="rgb-value ctmd-copy-me"><?php 
                echo esc_html( CTMD_Utilities::hex_to_rgb( $ctmd_resolved_color ) );
                ?></small></td>
										</tr>
										<?php 
            }
            ?>
									</tbody>
								</table>
							</div>
						</div>
					<?php 
        }
        ?>
				</div>
			</div>
		<?php 
    }
    ?>
	<?php 
}
?>
	</div>
	<hr class="ctmd-section-divider">

	<h2><?php 
esc_html_e( 'Standalone Palettes', 'color-theme-manager-for-divi' );
?></h2>
	<p><?php 
esc_html_e( 'These are single palettes you have saved. You can restore or delete them individually.', 'color-theme-manager-for-divi' );
?></p>

	<?php 
if ( empty( $ctmd_palettes ) ) {
    ?>
		<p><?php 
    esc_html_e( 'No standalone palettes found. You can create one from the "Color Manager" tab.', 'color-theme-manager-for-divi' );
    ?></p>
	<?php 
} else {
    ?>
		<?php 
    foreach ( $ctmd_palettes as $ctmd_palette_name => $ctmd_palette_data ) {
        ?>
			<div class="ctmd-palette-card">
				<h3><?php 
        echo esc_html( $ctmd_palette_name );
        ?></h3>
				<div class="ctmd-palette-actions">
					<form method="post" action="<?php 
        echo esc_url( admin_url( 'admin-post.php' ) );
        ?>">
						<input type="hidden" name="action" value="ctmd_restore_palette">
						<input type="hidden" name="palette_name" value="<?php 
        echo esc_attr( $ctmd_palette_name );
        ?>">
						<?php 
        wp_nonce_field( 'ctmd_restore_nonce' );
        ?>
						<?php 
        $ctmd_confirm_message = esc_js( __( 'Are you sure you want to restore colors from this palette? This will overwrite your current color configuration.', 'color-theme-manager-for-divi' ) );
        $ctmd_confirm_message .= '\\n\\n' . esc_js( __( 'IMPORTANT: If this action deletes a color that is currently in use, the reference will NOT be updated automatically. You will need to update it manually.', 'color-theme-manager-for-divi' ) );
        submit_button(
            esc_html__( 'Restore Colors from this Palette', 'color-theme-manager-for-divi' ),
            'primary',
            'restore_palette',
            false,
            array(
                'onclick' => 'return confirm("' . $ctmd_confirm_message . '");',
            )
        );
        ?>
					</form>
					<form method="post" action="<?php 
        echo esc_url( admin_url( 'admin-post.php' ) );
        ?>">
						<input type="hidden" name="action" value="ctmd_delete_palette">
						<input type="hidden" name="palette_name" value="<?php 
        echo esc_attr( $ctmd_palette_name );
        ?>">
						<?php 
        wp_nonce_field( 'ctmd_delete_palette_nonce' );
        ?>
						<?php 
        submit_button(
            esc_html__( 'Delete Palette', 'color-theme-manager-for-divi' ),
            'delete',
            'delete_palette',
            false,
            array(
                'onclick' => 'return confirm("' . esc_js( __( 'Are you sure you want to delete this palette?', 'color-theme-manager-for-divi' ) ) . '");',
            )
        );
        ?>
					</form>
				</div>
				<table class="wp-list-table widefat fixed striped">
					<thead>
						<tr>
							<th class="col-label"><?php 
        esc_html_e( 'Label', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-id"><?php 
        esc_html_e( 'ID', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-hex"><?php 
        esc_html_e( 'HEX', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-linked"><?php 
        esc_html_e( 'Linked Color', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-hsl"><?php 
        esc_html_e( 'HSL', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-rgb"><?php 
        esc_html_e( 'RGB', 'color-theme-manager-for-divi' );
        ?></th>
							<th class="col-status"><?php 
        esc_html_e( 'Status', 'color-theme-manager-for-divi' );
        ?></th>
						</tr>
					</thead>
					<tbody>
						<?php 
        // Build a complete color map for the resolver.
        $ctmd_resolver_map = array();
        if ( !empty( $ctmd_palette_data['global_colors'] ) ) {
            $ctmd_resolver_map = $ctmd_palette_data['global_colors'];
        }
        if ( !empty( $ctmd_palette_data['special_colors'] ) ) {
            foreach ( $ctmd_palette_data['special_colors'] as $ctmd_id => $ctmd_color ) {
                $ctmd_display_id = $this->special_color_display_ids[$ctmd_id] ?? $ctmd_id;
                $ctmd_resolver_map[$ctmd_display_id] = array(
                    'label' => $this->special_colors_map[$ctmd_id] ?? $ctmd_id,
                    'color' => $ctmd_color,
                );
            }
        }
        // Prepare the final list of colors to display in order.
        $ctmd_display_colors = array();
        if ( !empty( $ctmd_palette_data['special_colors'] ) ) {
            foreach ( $ctmd_palette_data['special_colors'] as $ctmd_id => $ctmd_color ) {
                $ctmd_display_id = $this->special_color_display_ids[$ctmd_id] ?? $ctmd_id;
                $ctmd_display_colors[$ctmd_display_id] = array(
                    'label'  => $this->special_colors_map[$ctmd_id] ?? $ctmd_id,
                    'color'  => $ctmd_color,
                    'status' => 'active',
                );
            }
        }
        if ( !empty( $ctmd_palette_data['global_colors'] ) ) {
            foreach ( $ctmd_palette_data['global_colors'] as $ctmd_id => $ctmd_color_data ) {
                $ctmd_display_colors[$ctmd_id] = $ctmd_color_data;
            }
        }
        foreach ( $ctmd_display_colors as $ctmd_id => $ctmd_data ) {
            $ctmd_status = $ctmd_data['status'] ?? 'active';
            $ctmd_resolved_color = CTMD_Utilities::resolve_color( $ctmd_data['color'], $ctmd_resolver_map );
            $ctmd_is_derivative = strpos( $ctmd_data['color'], '$variable' ) === 0;
            $ctmd_parent_name = ( $ctmd_is_derivative ? CTMD_Utilities::get_parent_name( $ctmd_data['color'], $ctmd_resolver_map ) : '' );
            ?>
						<tr class="<?php 
            echo ( 'inactive' === $ctmd_status ? 'inactive-row' : '' );
            ?>">
							<td><?php 
            echo esc_html( $ctmd_data['label'] );
            ?></td>
							<td><code><?php 
            echo esc_html( $ctmd_id );
            ?></code></td>
							<td>
								<span class="ctmd-color-swatch" data-color="<?php 
            echo esc_attr( $ctmd_resolved_color );
            ?>"></span>
								<span class="hex-value ctmd-copy-me"><?php 
            echo esc_html( CTMD_Utilities::normalize_to_hex( $ctmd_resolved_color ) );
            ?></span>
							</td>
							<td><?php 
            echo esc_html( $ctmd_parent_name );
            ?></td>
							<td><small class="hsl-value ctmd-copy-me"><?php 
            echo esc_html( CTMD_Utilities::hex_to_hsl( $ctmd_resolved_color ) );
            ?></small></td>
							<td><small class="rgb-value ctmd-copy-me"><?php 
            echo esc_html( CTMD_Utilities::hex_to_rgb( $ctmd_resolved_color ) );
            ?></small></td>
							<td><?php 
            echo esc_html( ucfirst( $ctmd_status ) );
            ?></td>
						</tr>
						<?php 
        }
        ?>
					</tbody>
				</table>
			</div>
		<?php 
    }
    ?>
	<?php 
}
?>
</div>
