<?php

/**
 * View: How To Page
 *
 * Displays detailed instructions, screenshots, and tutorials on how to use
 * the various features of the plugin (Color Manager, Theme Generator, etc.).
 *
 * @package Color_Theme_Manager_For_Divi
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
?>
<div class="wrap ctmd-how-to ctmd-lightbox-gallery">
	<h1><?php 
esc_html_e( 'How to Use the Color Theme Manager', 'color-theme-manager-for-divi' );
?></h1>

	<h2><?php 
esc_html_e( 'Option 1: Extended Divi Color Management', 'color-theme-manager-for-divi' );
?></h2>
	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'The Ultimate Global Color Editor—No Builder Required!', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( "We're taking Divi's functionality to the next level. For the first time, you have the power to manage your entire Global Color Palette directly from this interface, saving you countless clicks and loading time.", 'color-theme-manager-for-divi' );
?>
		</p>
		<p>
			<?php 
esc_html_e( "Here's what you can now do in seconds:", 'color-theme-manager-for-divi' );
?>
		</p>
		<ul>
			<li><strong><?php 
esc_html_e( 'Add & Modify:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Instantly add new colors or edit existing ones.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Relative HSL Colors:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Define dynamic, relative colors using HSL values.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Full CSS Control:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Edit the global CSS variable name for any color.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Drag & Drop Reordering:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Effortlessly change the display order of your colors.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'One-Click Color Copy:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Instantly copy any color code (HEX, RGB, or HSL) directly to your clipboard.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Recover Deleted Colors:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Accidentally removed a color in the Divi Builder? Reactivate it with a single click!', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Safely Delete:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( " Permanently delete any color, as long as it's not currently in use.", 'color-theme-manager-for-divi' );
?></li>
		</ul>
		<p>
			<?php 
esc_html_e( '...and this is just the beginning. Stay tuned for more game-changing features!', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-2.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-2.png' );
?>" alt="Select color theme json file">
		</a>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-3.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-3.png' );
?>" alt="Select color theme json file">
		</a>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-4.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-4.png' );
?>" alt="Select color theme json file">
		</a>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-5.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-5.png' );
?>" alt="Select color theme json file">
		</a>
	</div>

	<div class="ctmd-card mb-40">
		<h2><?php 
esc_html_e( 'Never Lose a Great Color Scheme Again!', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Want to try a new look for a special promotion or a holiday season without losing your main brand colors? Now you can experiment with total peace of mind.', 'color-theme-manager-for-divi' );
?>
		</p>
		<ul>
			<li><strong><?php 
esc_html_e( 'Save Snapshots:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Store your entire active color palette as a named preset in your personal library with a single click.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'Experiment Freely:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Go ahead and create new color combinations. Your saved palettes are always kept safe.', 'color-theme-manager-for-divi' );
?></li>
			<li><strong><?php 
esc_html_e( 'One-Click Restore:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Instantly switch back to any of your saved palettes at any time. Your perfect color scheme is always just a click away.', 'color-theme-manager-for-divi' );
?></li>
		</ul>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-6.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-6.png' );
?>" alt="Select color theme json file">
		</a>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-7.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-manager-7.png' );
?>" alt="Select color theme json file">
		</a>
	</div>

	<?php 
?>
		<div class="ctmd-premium-feature-notice">
			<h2><?php 
esc_html_e( 'Theme Generation is a Premium Feature', 'color-theme-manager-for-divi' );
?></h2>
			<p><?php 
esc_html_e( 'Upgrade to the premium version to unlock this feature and many more!', 'color-theme-manager-for-divi' );
?></p>
			<a href="<?php 
echo esc_url( ctmd_fs()->get_upgrade_url() );
?>" class="button button-primary"><?php 
esc_html_e( 'Upgrade Now', 'color-theme-manager-for-divi' );
?></a>
		</div>
	<?php 
?>
	<div class="
	<?php 
echo 'ctmd-disabled-section';
?>
	">
	<h2><?php 
esc_html_e( 'Option 2: Theme Generation', 'color-theme-manager-for-divi' );
?>
	<?php 
?>
		<span class="ctmd-premium-badge">Premium</span><?php 
?></h2>
	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'Step 1: Generate a Theme', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Navigate to the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Theme Generator', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' tab and enter a custom name for your new theme.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-1.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-1.png' );
?>" alt="Select color theme json file">
		</a>
		<p>
			<?php 
esc_html_e( 'Click ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( '"Choose File"', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' and select the .json file you previously exported from websitestylekit.com.', 'color-theme-manager-for-divi' );
?>
			<br><em>(<?php 
esc_html_e( 'Note: The plugin currently reads the "Primary Palette" from the websitestylekit.com v2.0 JSON export.', 'color-theme-manager-for-divi' );
?>)</em>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-2.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-2.png' );
?>" alt="Preview colors of selected json file">
		</a>
		<p>
			<?php 
esc_html_e( 'The colors from your file will be displayed for preview. If everything looks correct, click the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( '"Generate Theme Palettes"', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' button.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-3.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-3.png' );
?>" alt="Approve and generate color theme palette">
		</a>
	</div>

	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'Step 2: Review Your Color Contrast', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Once your palettes are generated, our built-in Contrast Checker automatically analyzes each color combination for readability. This crucial step ensures your design is accessible and meets WCAG standards.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-contrast-checker-1.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-contrast-checker-1.png' );
?>" alt="Screenshot of the contrast checker results">
		</a>
		<p>
			<?php 
esc_html_e( 'Look for the Fail ', 'color-theme-manager-for-divi' );
?><strong class="fail-indicator"><span class="dashicons dashicons-warning"></span></strong><?php 
esc_html_e( ' indicators next to each color pair.', 'color-theme-manager-for-divi' );
?>
			<?php 
esc_html_e( 'If a combination fails, we recommend adjusting the colors by clicking ', 'color-theme-manager-for-divi' );
?><strong class="fail-indicator"><span class="dashicons dashicons-warning"></span></strong><?php 
esc_html_e( ' to improve readability before proceeding to the full preview.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-contrast-checker-2.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-contrast-checker-2.png' );
?>" alt="Highlighting several color pairs that fail WCAG accessibility standards">
		</a>
	</div>

	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'Step 3: Preview Your Theme', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Go to the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Preview', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' tab.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-1.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-1.png' );
?>" alt="Select theme for preview">
		</a>
		<p>
			<?php 
esc_html_e( 'From the main dropdown menu, select the theme you created in the previous step.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-2.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-2.png' );
?>" alt="Approve and generate color theme palette">
		</a>
		<p>
			<?php 
esc_html_e( 'Use the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Theme Mode', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' dropdown on the right to instantly switch between the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Light, Dark, and Mixed', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' versions of your palette.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-4.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-4.png' );
?>" alt="Approve and generate color theme palette">
		</a>
		<p>
			<?php 
esc_html_e( 'Explore the various sections and elements on the page to see how your new color scheme looks live.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-3.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-preview-3.png' );
?>" alt="Approve and generate color theme palette">
		</a>
	</div>

	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'Step 4: Activate Your Theme', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Navigate to the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Palette Manager', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' tab. Here you will see a list of all the theme palettes you have created.', 'color-theme-manager-for-divi' );
?>
		</p>
		<p>
			<?php 
esc_html_e( 'Locate the theme you wish to use on your live site and click the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( '"Activate"', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' button.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-3.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-generator-3.png' );
?>" alt="Select and activate color theme palette">
		</a>
		<p>
			<strong><?php 
esc_html_e( 'What Happens Next:', 'color-theme-manager-for-divi' );
?></strong>
		</p>
		<p>
			<strong><?php 
esc_html_e( 'Your Theme is Active:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Your selected color scheme is now applied across your entire website.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-activation-1.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-activation-1.png' );
?>" alt="Select and activate color theme palette">
		</a>
		<p>
			<strong><?php 
esc_html_e( 'Color Management is Synced:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' Your palette is now locked in to ensure consistency. Manual overrides are possible via ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Divi Builder → Global Colors', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' but are not recommended.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-activation-2.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-theme-activation-2.png' );
?>" alt="Color theme palette locked">
		</a>
		<p>
			<strong><?php 
esc_html_e( 'Mode Switcher is Live:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' The Light/Dark/Mixed mode switcher has been automatically enabled for your visitors on the front end.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-switcher-enabled.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-color-switcher-enabled.png' );
?>" alt="Theme mode switcher enabled">
		</a>
	</div>

	<div class="ctmd-card">
		<h2><?php 
esc_html_e( 'Step 5: Import the Pre-Styled Master Layout', 'color-theme-manager-for-divi' );
?></h2>
		<p>
			<?php 
esc_html_e( 'Navigate to the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Settings', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' tab to access the download.', 'color-theme-manager-for-divi' );
?>
		</p>
		<p>
			<?php 
esc_html_e( 'Click the ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( '"Download Master Layout"', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' button to get our pre-styled .json file.', 'color-theme-manager-for-divi' );
?>
		</p>
		<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-settings-page.png' );
?>">
			<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/ctmd-settings-page.png' );
?>" alt="Theme mode switcher enabled">
		</a>
		<p>
			<?php 
esc_html_e( 'Go to a new or existing Divi page (e.g., a "Color Guide" page), open the Divi Builder, and import this .json file.', 'color-theme-manager-for-divi' );
?>
		</p>
		<p>
			<strong><?php 
esc_html_e( 'What you get:', 'color-theme-manager-for-divi' );
?></strong><?php 
esc_html_e( ' This will instantly load a library of predefined presets ready to use on any section or element, all perfectly synced with your active color palette, and build your pages faster than ever.', 'color-theme-manager-for-divi' );
?>
		</p>
	</div>
	</div>
</div>
