<?php
/**
 * View: Color Manager Tab
 *
 * Displays the main interface for managing global colors, special Divi colors,
 * adding new colors, and handling derivative color settings.
 *
 * @package Color_Theme_Manager_For_Divi
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// The $this variable is an instance of CTMD_Admin.
// ΟΛΕΣ οι μεταβλητές εδώ έχουν πλέον το prefix 'ctmd_'.
$ctmd_settings          = get_option( 'ctmd_settings', array() );
$ctmd_active_theme_name = $ctmd_settings['active_theme_name'] ?? null;
$ctmd_is_locked         = ! empty( $ctmd_active_theme_name );
?>
<div id="ctmd-colors-manager" class="<?php echo $ctmd_is_locked ? 'ctmd-is-locked' : ''; ?>">
	<?php
	if ( $ctmd_is_locked ) :
		$ctmd_palette_manager_url = admin_url( 'admin.php?page=color-theme-manager-for-divi&tab=palettes' );
		?>
		<div class="notice notice-info inline">
			<p>
				<?php
				printf(
					/* translators: %1$s is the active theme name, %2$s is the URL to the palette manager. */
					wp_kses_post( __( 'Theme <strong>"%1$s"</strong> is currently active. To prevent accidental changes, the Color Manager is locked. You can deactivate the theme from the <a href="%2$s">Palette Manager</a>.', 'color-theme-manager-for-divi' ) ),
					esc_html( $ctmd_active_theme_name ),
					esc_url( $ctmd_palette_manager_url )
				);
				?>
			</p>
		</div>
	<?php endif; ?>
	<h2><?php esc_html_e( 'Add New Color', 'color-theme-manager-for-divi' ); ?></h2>
	<form id="ctmd-add-color-form" class="ctmd-tracked-form" method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
		<input type="hidden" name="action" value="ctmd_add_new_color">
		<?php wp_nonce_field( 'ctmd_add_new_color_nonce' ); ?>
		<table class="wp-list-table widefat fixed striped">
			<thead>
				<tr>
					<th class="col-color-id"><?php esc_html_e( 'Color ID', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-label"><?php esc_html_e( 'Label', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-color"><?php esc_html_e( 'Color', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-hex"><?php esc_html_e( 'HEX', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-hsl"><?php esc_html_e( 'HSL', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-rgb"><?php esc_html_e( 'RGB', 'color-theme-manager-for-divi' ); ?></th>
				</tr>
			</thead>
			<tbody id="ctmd-add-color-row">
				<tr class="ctmd-add-new-row">
					<td><input type="text" class="regular-text" name="new_color[id]" placeholder="gcid-... or custom-name" <?php disabled( $ctmd_is_locked, true ); ?> /></td>
					<td><input type="text" class="regular-text" name="new_color[label]" placeholder="e.g. Primary Brand Color" <?php disabled( $ctmd_is_locked, true ); ?> /></td>
					<td>
						<div class="ctmd-color-input-wrapper">
							<span class="ctmd-color-swatch" data-color="#000000"></span>
							<input type="text" value="#000000" class="ctmd-color-input-display" <?php disabled( $ctmd_is_locked, true ); ?> />
							<input type="hidden" name="new_color[color]" value="#000000" class="ctmd-color-input" />
							<button type="button" class="button button-secondary button-small ctmd-derivative-link-btn" title="<?php esc_attr_e( 'Make this a derivative color', 'color-theme-manager-for-divi' ); ?>" <?php disabled( $ctmd_is_locked, true ); ?>>
								<span class="dashicons dashicons-admin-links"></span>
							</button>
						</div>
					</td>
					<td><span class="hex-value">#000000</span></td>
					<td><small class="hsl-value">hsl(0, 0%, 0%)</small></td>
					<td><small class="rgb-value">rgb(0, 0, 0)</small></td>
				</tr>
			</tbody>
		</table>
		<?php submit_button( esc_html__( 'Add New Color', 'color-theme-manager-for-divi' ), 'primary', 'add_new_color_submit', true, $ctmd_is_locked ? array( 'disabled' => 'disabled' ) : null ); ?>
	</form>

	<h2 class="title"><?php esc_html_e( 'Edit Colors', 'color-theme-manager-for-divi' ); ?></h2>
	<form id="ctmd-colors-form" class="ctmd-tracked-form" method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
		<input type="hidden" name="action" value="ctmd_save_colors">
		<input type="hidden" name="ctmd_color_order" id="ctmd-color-order" value="">
		<?php wp_nonce_field( 'ctmd_save_colors_nonce' ); ?>
		<table class="wp-list-table widefat fixed striped">
			<thead>
				<tr>
					<th class="col-drag"></th>
					<th class="col-color-id"><?php esc_html_e( 'Color ID (Editable)', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-label"><?php esc_html_e( 'Label', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-color"><?php esc_html_e( 'Color', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-hex"><?php esc_html_e( 'HEX', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-hsl"><?php esc_html_e( 'HSL', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-rgb"><?php esc_html_e( 'RGB', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-status"><?php esc_html_e( 'Status', 'color-theme-manager-for-divi' ); ?></th>
					<th class="col-delete"><?php esc_html_e( 'Delete*', 'color-theme-manager-for-divi' ); ?></th>
				</tr>
			</thead>
			<tbody id="ctmd-sortable-colors">
				<?php
				$ctmd_colors                  = $this->color_manager->get_global_colors();
				$ctmd_et_divi_options         = get_option( 'et_divi', array() );
				$ctmd_all_colors_for_resolver = $ctmd_colors;

				foreach ( $this->special_colors_map as $ctmd_key => $ctmd_label ) {
					$ctmd_color_value = $ctmd_et_divi_options[ $ctmd_key ] ?? $this->default_special_colors[ $ctmd_key ];
					$ctmd_all_colors_for_resolver[ $this->special_color_display_ids[ $ctmd_key ] ] = array(
						'color' => $ctmd_color_value,
						'label' => $ctmd_label,
					);
				}

				foreach ( $this->special_colors_map as $ctmd_key => $ctmd_label ) :
					$ctmd_color_value    = $ctmd_et_divi_options[ $ctmd_key ] ?? $this->default_special_colors[ $ctmd_key ];
					$ctmd_is_derivative  = strpos( $ctmd_color_value, '$variable' ) === 0;
					$ctmd_resolved_color = CTMD_Utilities::resolve_color( $ctmd_color_value, $ctmd_all_colors_for_resolver );
					$ctmd_parent_color   = $ctmd_is_derivative ? CTMD_Utilities::get_parent_color( $ctmd_color_value, $ctmd_all_colors_for_resolver ) : $ctmd_resolved_color;
					$ctmd_display_value  = $ctmd_is_derivative ? CTMD_Utilities::get_parent_name( $ctmd_color_value, $ctmd_all_colors_for_resolver ) : $ctmd_resolved_color;
					?>
					<tr class="ctmd-special-color-row">
						<td class="col-drag-handle">-</td>
						<td><input type="text" class="regular-text" value="<?php echo esc_attr( $this->special_color_display_ids[ $ctmd_key ] ); ?>" readonly disabled /></td>
						<td><input type="text" class="regular-text" value="<?php echo esc_attr( $ctmd_label ); ?>" readonly disabled /></td>
						<td>
							<div class="ctmd-color-input-wrapper">
								<span class="ctmd-color-swatch <?php echo $ctmd_is_derivative ? 'is-derivative' : ''; ?>" data-color="<?php echo esc_attr( $ctmd_resolved_color ); ?>"></span>
								<input type="text" value="<?php echo esc_attr( $ctmd_display_value ); ?>" class="ctmd-color-input-display" readonly />
								<input type="hidden" name="special_colors[<?php echo esc_attr( $ctmd_key ); ?>]" value="<?php echo esc_attr( $ctmd_color_value ); ?>" class="ctmd-color-input" />
								<button type="button" class="button button-secondary button-small ctmd-derivative-link-btn" title="<?php esc_attr_e( 'Make this a derivative color', 'color-theme-manager-for-divi' ); ?>" data-color="<?php echo $ctmd_is_derivative ? esc_attr( $ctmd_parent_color ) : ''; ?>" <?php disabled( $ctmd_is_locked, true ); ?>>
									<span class="dashicons dashicons-admin-links"></span>
								</button>
							</div>
						</td>
						<td><span class="hex-value ctmd-copy-me"><?php echo esc_html( CTMD_Utilities::normalize_to_hex( $ctmd_resolved_color ) ); ?></span></td>
						<td><small class="hsl-value ctmd-copy-me"><?php echo esc_html( CTMD_Utilities::hex_to_hsl( $ctmd_resolved_color ) ); ?></small></td>
						<td><small class="rgb-value ctmd-copy-me"><?php echo esc_html( CTMD_Utilities::hex_to_rgb( $ctmd_resolved_color ) ); ?></small></td>
						<td class="col-status">-</td>
						<td class="col-delete">-</td>
					</tr>
				<?php endforeach; ?>

				<?php if ( empty( $ctmd_colors ) ) : ?>
					<tr>
						<td colspan="9"><?php esc_html_e( 'No custom global colors found.', 'color-theme-manager-for-divi' ); ?></td>
					</tr>
				<?php else : ?>
					<?php
					foreach ( $ctmd_colors as $ctmd_id => $ctmd_color_data ) :
						$ctmd_is_derivative  = strpos( $ctmd_color_data['color'], '$variable' ) === 0;
						$ctmd_resolved_color = CTMD_Utilities::resolve_color( $ctmd_color_data['color'], $ctmd_all_colors_for_resolver );
						$ctmd_parent_color   = $ctmd_is_derivative ? CTMD_Utilities::get_parent_color( $ctmd_color_data['color'], $ctmd_all_colors_for_resolver ) : $ctmd_resolved_color;
						$ctmd_display_value  = $ctmd_is_derivative ? CTMD_Utilities::get_parent_name( $ctmd_color_data['color'], $ctmd_all_colors_for_resolver ) : $ctmd_resolved_color;
						$ctmd_is_inactive    = ( $ctmd_color_data['status'] ?? 'active' ) === 'inactive';
						$ctmd_copy_class     = $ctmd_is_inactive ? 'inactive' : 'ctmd-copy-me';
						?>
						<tr data-color-id="<?php echo esc_attr( $ctmd_id ); ?>" class="ctmd-color-row <?php echo $ctmd_is_inactive ? 'inactive' : ''; ?>">
							<td class="ctmd-drag-handle"><span class="dashicons dashicons-menu"></span></td>
							<td>
								<input type="text" class="regular-text" name="colors[<?php echo esc_attr( $ctmd_id ); ?>][id]" value="<?php echo esc_attr( $ctmd_color_data['id'] ); ?>" <?php disabled( $ctmd_is_locked || $ctmd_is_inactive ); ?> />
							</td>
							<td>
								<input type="text" class="regular-text" name="colors[<?php echo esc_attr( $ctmd_id ); ?>][label]" value="<?php echo esc_attr( $ctmd_color_data['label'] ); ?>" <?php disabled( $ctmd_is_locked || $ctmd_is_inactive ); ?> />
							</td>
							<td>
								<div class="ctmd-color-input-wrapper">
									<span class="ctmd-color-swatch <?php echo $ctmd_is_derivative ? 'is-derivative' : ''; ?> <?php echo $ctmd_is_inactive ? 'inactive' : ''; ?>" data-color="<?php echo esc_attr( $ctmd_resolved_color ); ?>"></span>
									<input type="text" value="<?php echo esc_attr( $ctmd_display_value ); ?>" class="ctmd-color-input-display" readonly <?php disabled( $ctmd_is_locked || $ctmd_is_inactive ); ?> />
									<input type="hidden" name="colors[<?php echo esc_attr( $ctmd_id ); ?>][color]" value="<?php echo esc_attr( $ctmd_color_data['color'] ); ?>" class="ctmd-color-input" <?php disabled( $ctmd_is_locked || $ctmd_is_inactive ); ?> />
									<button type="button" class="button button-secondary button-small ctmd-derivative-link-btn" title="<?php esc_attr_e( 'Make this a derivative color', 'color-theme-manager-for-divi' ); ?>" data-color="<?php echo $ctmd_is_derivative ? esc_attr( $ctmd_parent_color ) : ''; ?>" <?php disabled( $ctmd_is_locked || $ctmd_is_inactive ); ?>>
										<span class="dashicons dashicons-admin-links"></span>
									</button>
								</div>
							</td>
							<td><span class="hex-value <?php echo esc_attr( $ctmd_copy_class ); ?>"><?php echo esc_html( CTMD_Utilities::normalize_to_hex( $ctmd_resolved_color ) ); ?></span></td>
							<td><small class="hsl-value <?php echo esc_attr( $ctmd_copy_class ); ?>"><?php echo esc_html( CTMD_Utilities::hex_to_hsl( $ctmd_resolved_color ) ); ?></small></td>
							<td><small class="rgb-value <?php echo esc_attr( $ctmd_copy_class ); ?>"><?php echo esc_html( CTMD_Utilities::hex_to_rgb( $ctmd_resolved_color ) ); ?></small></td>
							<td class="col-status">
								<input type="checkbox" name="colors[<?php echo esc_attr( $ctmd_id ); ?>][status]" value="active" <?php checked( $ctmd_color_data['status'] ?? 'active', 'active' ); ?> <?php disabled( $ctmd_is_locked ); ?> />
							</td>
							<td class="col-delete">
								<input type="checkbox" name="colors[<?php echo esc_attr( $ctmd_id ); ?>][delete]" value="1" <?php disabled( $ctmd_is_locked ); ?> />
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
		<p class="description">
			* <?php esc_html_e( 'If a color is currently in use on your site, checking "Delete" will deactivate it instead of deleting it permanently. If the color is not in use, it will be permanently deleted.', 'color-theme-manager-for-divi' ); ?>
		</p>
		<?php submit_button( esc_html__( 'Save Changes', 'color-theme-manager-for-divi' ), 'primary', 'save_changes_submit', true, $ctmd_is_locked ? array( 'disabled' => 'disabled' ) : null ); ?>

		<div id="ctmd-derivative-modal">
			<h2 id="ctmd-derivative-modal-title"><?php esc_html_e( 'Derivative Color Settings', 'color-theme-manager-for-divi' ); ?></h2>
			<button type="button" id="ctmd-remove-link-btn" class="button button-link-delete"><?php esc_html_e( 'Remove Link', 'color-theme-manager-for-divi' ); ?></button>
			<hr>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row"><label for="ctmd-parent-color"><?php esc_html_e( 'Parent Color', 'color-theme-manager-for-divi' ); ?></label></th>
						<td>
							<select id="ctmd-parent-color"></select>
							<span id="ctmd-parent-color-swatch"></span>
						</td>
					</tr>
					<tr class="ctmd-slider-container">
						<th scope="row"><label for="ctmd-hue-slider"><?php esc_html_e( 'Hue', 'color-theme-manager-for-divi' ); ?></label></th>
						<td>
							<input type="range" id="ctmd-hue-slider" min="-180" max="180" value="0">
							<input type="number" id="ctmd-hue-value" min="-180" max="180" value="0">
						</td>
					</tr>
					<tr class="ctmd-slider-container">
						<th scope="row"><label for="ctmd-saturation-slider"><?php esc_html_e( 'Saturation', 'color-theme-manager-for-divi' ); ?></label></th>
						<td>
							<input type="range" id="ctmd-saturation-slider" min="-100" max="100" value="0">
							<input type="number" id="ctmd-saturation-value" min="-100" max="100" value="0">
						</td>
					</tr>
					<tr class="ctmd-slider-container">
						<th scope="row"><label for="ctmd-lightness-slider"><?php esc_html_e( 'Lightness', 'color-theme-manager-for-divi' ); ?></label></th>
						<td>
							<input type="range" id="ctmd-lightness-slider" min="-100" max="100" value="0">
							<input type="number" id="ctmd-lightness-value" min="-100" max="100" value="0">
						</td>
					</tr>
					<tr class="ctmd-slider-container">
						<th scope="row"><label for="ctmd-opacity-slider"><?php esc_html_e( 'Opacity', 'color-theme-manager-for-divi' ); ?></label></th>
						<td>
							<input type="range" id="ctmd-opacity-slider" min="0" max="100" value="100">
							<input type="number" id="ctmd-opacity-value" min="0" max="100" value="100">
						</td>
					</tr>
				</tbody>
			</table>
			<div class="ctmd-modal-actions">
				<div class="ctmd-modal-preview">
					<strong><?php esc_html_e( 'Preview:', 'color-theme-manager-for-divi' ); ?></strong>
					<span id="ctmd-derivative-preview-swatch"></span>
				</div>
				<div>
					<button type="button" id="ctmd-derivative-save-btn" class="button button-primary button-large"><?php esc_html_e( 'Save', 'color-theme-manager-for-divi' ); ?></button>
					<button type="button" id="ctmd-derivative-cancel-btn" class="button button-secondary button-large"><?php esc_html_e( 'Cancel', 'color-theme-manager-for-divi' ); ?></button>
				</div>
			</div>
		</div>
		<div id="ctmd-modal-backdrop"></div>

	</form>

	<hr>

	<h2 class="title"><?php esc_html_e( 'Create Palette from Current Colors', 'color-theme-manager-for-divi' ); ?></h2>
	<p><?php esc_html_e( 'Save the current color configuration (above) as a new palette snapshot.', 'color-theme-manager-for-divi' ); ?></p>
	<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
		<input type="hidden" name="action" value="ctmd_create_palette">
		<?php wp_nonce_field( 'ctmd_create_palette_nonce' ); ?>
		<input type="text" name="palette_name" placeholder="<?php esc_attr_e( 'New Palette Name', 'color-theme-manager-for-divi' ); ?>" class="regular-text" required <?php disabled( $ctmd_is_locked, true ); ?>>
		<?php submit_button( esc_html__( 'Create Palette Snapshot', 'color-theme-manager-for-divi' ), 'primary', 'create_palette_submit', false, $ctmd_is_locked ? array( 'disabled' => 'disabled' ) : null ); ?>
	</form>
</div>
