<?php

/**
 * View: About Page
 *
 * Displays information about the plugin, credits, and links to documentation.
 *
 * @package Color_Theme_Manager_For_Divi
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
?>
<div class="wrap" id="ctmd-about-page">
	<div class="ctmd-about-section">
		<h2><?php 
esc_html_e( 'About the Plugin', 'color-theme-manager-for-divi' );
?></h2>
		<div class="ctmd-card">
			<p><?php 
esc_html_e( 'Welcome to ', 'color-theme-manager-for-divi' );
?><strong><?php 
esc_html_e( 'Color Theme Manager for Divi!', 'color-theme-manager-for-divi' );
?></strong></p>
			<p><?php 
esc_html_e( 'We created this tool to give you ultimate and intuitive control over your Divi Global Colors, saving you time and unlocking your creativity.', 'color-theme-manager-for-divi' );
?></p>
			<p><strong><?php 
esc_html_e( 'Key Features:', 'color-theme-manager-for-divi' );
?></strong></p>
			<ul>
				<li><strong><?php 
esc_html_e( 'Total Palette Control:', 'color-theme-manager-for-divi' );
?></strong> <?php 
esc_html_e( 'Create, save, and switch between advanced color palettes instantly.', 'color-theme-manager-for-divi' );
?></li>
				<li><strong><?php 
esc_html_e( 'Automatic Light, Dark or Mixed Modes', 'color-theme-manager-for-divi' );
?></strong> <span class="ctmd-premium-badge">Premium</span> <?php 
esc_html_e( 'Implement a theme switcher that works flawlessly with your defined colors.', 'color-theme-manager-for-divi' );
?></li>
				<li><strong><?php 
esc_html_e( 'Accessibility-Ready Palettes', 'color-theme-manager-for-divi' );
?></strong> <span class="ctmd-premium-badge">Premium</span> <?php 
esc_html_e( 'Automatically checks color contrast ratios to ensure they meet WCAG readability standards.', 'color-theme-manager-for-divi' );
?></li>
				<li><strong><?php 
esc_html_e( 'Easy Import/Export', 'color-theme-manager-for-divi' );
?></strong> <span class="ctmd-premium-badge">Premium</span> <?php 
esc_html_e( 'Transfer your entire color setup to another website in seconds.', 'color-theme-manager-for-divi' );
?></li>
			</ul>
		</div>
		<div class="ctmd-card ctmd-card-2">
			<p><strong><?php 
esc_html_e( 'Ready to transform your workflow?', 'color-theme-manager-for-divi' );
?></strong></p>
			<ul>
				<li>
					<?php 
?>
						<span class="ctmd-disabled-link"><?php 
esc_html_e( 'Go to Theme Generator to create your first color theme palette.', 'color-theme-manager-for-divi' );
?></span> <span class="ctmd-premium-badge">Premium</span>
					<?php 
?>
				</li>
				<li>
					<?php 
$ctmd_url = admin_url( 'admin.php?page=color-theme-manager-for-divi&tab=howto' );
echo wp_kses_post( sprintf( 
    /* translators: %1$s: <a> tag, %2$s: </a> tag */
    __( 'Read the %1$sHow To%2$s instructions to quickly set up your color schemes.', 'color-theme-manager-for-divi' ),
    '<a href="' . esc_url( $ctmd_url ) . '" target="_blank">',
    '</a>'
 ) );
?>
				</li>
			</ul>
		</div>
	</div>

	<div class="ctmd-about-section">
		<h2><?php 
esc_html_e( 'About Us', 'color-theme-manager-for-divi' );
?></h2>
		<div class="ctmd-card">
			<p>
				<a href="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/divinous-wordmark.svg' );
?>">
					<img src="<?php 
echo esc_url( CTMD_PLUGIN_URL . 'assets/images/divinous-wordmark.svg' );
?>" alt="diViNOUS logo" class="divinous-logo">
				</a>
				<?php 
esc_html_e( ' is a small team of passionate developers and designers focused on the Divi ecosystem. We have been building professional websites for over a decade and create tools we\'d love to use ourselves.', 'color-theme-manager-for-divi' );
?>
			</p>
			<p><strong><?php 
esc_html_e( 'Our mission is to create powerful, intuitive, and reliable tools that streamline the web design process.', 'color-theme-manager-for-divi' );
?></strong></p>
		</div>
		<div class="ctmd-card ctmd-card-2">
			<p><strong><?php 
esc_html_e( 'Connect with Us:', 'color-theme-manager-for-divi' );
?></strong></p>
			<ul>
				<li><?php 
echo wp_kses_post( __( 'Visit our website: <a href="https://divinous.com" target="_blank">divinous.com</a>', 'color-theme-manager-for-divi' ) );
?></li>
			</ul>
		</div>
	</div>

	<div class="ctmd-about-section">
		<h2><?php 
esc_html_e( 'Feedback & Ideas', 'color-theme-manager-for-divi' );
?></h2>
		<div class="ctmd-card ctmd-card-2 ctmd-card-3">
			<p><strong><?php 
esc_html_e( 'Got an Idea? Suggest a Feature!', 'color-theme-manager-for-divi' );
?></strong></p>
			<p><?php 
esc_html_e( 'Your feedback is invaluable. Tell us how we can make this plugin even better for you.', 'color-theme-manager-for-divi' );
?></p>
			<a href="mailto:feedback@divinous.com" class="button button-primary"><?php 
esc_html_e( 'Share Your Ideas', 'color-theme-manager-for-divi' );
?></a>
		</div>
	</div>

	<div class="ctmd-about-section">
		<h2><?php 
esc_html_e( 'Credits', 'color-theme-manager-for-divi' );
?></h2>
		<div class="ctmd-card">
			<p>
				<?php 
echo wp_kses_post( sprintf( 
    /* translators: %s: Link to Elegant Themes website. */
    __( 'This plugin is an addon for the amazing Divi theme by %s.', 'color-theme-manager-for-divi' ),
    '<a href="https://www.elegantthemes.com" target="_blank" rel="noopener noreferrer">Elegant Themes</a>'
 ) );
?>
			</p>
		</div>
		<div class="ctmd-card ctmd-card-2">
			<p>
				<?php 
echo wp_kses_post( sprintf( 
    /* translators: %s: Link to Elegant Themes website. */
    __( 'A special thanks to Rino de Boer, the creator of %s, for his fantastic color palette generator.', 'color-theme-manager-for-divi' ),
    '<a href="https://websitestylekit.com" target="_blank" rel="noopener noreferrer">websitestylekit.com</a>'
 ) );
?>
			</p>
		</div>
	</div>
</div>
