<?php
defined('ABSPATH') || die('Restricted Access');

class LpcLabelGenerationAuto extends LpcComponent {

    protected $labelGenerationOutward;

    public function __construct(?LpcLabelGenerationOutward $labelGenerationOutward = null) {
        $this->labelGenerationOutward = LpcRegister::get('labelGenerationOutward', $labelGenerationOutward);
    }

    public function getDependencies(): array {
        return ['labelGenerationOutward'];
    }

    public function init() {
        add_action('woocommerce_order_status_changed', [$this, 'generateLabelsAuto'], 50, 4);
    }

    /**
     * Automatically generate the label if order status matches status from configuration
     *
     * @param int    $orderId
     * @param string $statusFrom
     * @param string $statusTo
     * @param object $order
     */
    public function generateLabelsAuto($orderId, $statusFrom, $statusTo, $order) {
        $orderStatuses = LpcHelper::get_option('lpc_generate_label_on', '');

        if (!is_array($orderStatuses)) {
            $orderStatuses = [$orderStatuses];
        }

        $disabled = in_array(LpcOrderStatuses::WC_LPC_DISABLE, $orderStatuses);
        if (empty($orderStatuses) || $statusFrom === $statusTo || $disabled) {
            return;
        }

        // WooCommerce removes the "wc-" prefix on the native order statuses that are sent in the hook
        if (in_array($statusTo, $orderStatuses) || in_array('wc-' . $statusTo, $orderStatuses)) {
            try {
                $allItemsOrder = $order->get_items();
                $this->labelGenerationOutward->generate(
                    $order,
                    [
                        'isAutoGeneration' => true,
                        'items'            => $allItemsOrder,
                    ],
                    true
                );
            } catch (Exception $e) {
                LpcLogger::error(__METHOD__, ['error' => $e->getMessage()]);
            }
        }
    }
}
