<?php

if (!defined('ABSPATH')) exit;

/**
 * Partial Template: Cocktail Recipe Controls
 *
 * Included via Output::render(); which limits variable scope to that method.
 */

use CocktailRecipes\Core\Helpers\Output;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
<?php if (Output::onlyOnce('control-defaults')): ?>
    <div class="cocktail-control-defaults"
        data-default-view="<?php echo esc_attr($default_view); ?>"
        data-default-servings="1"
        data-default-units="<?php echo esc_attr($default_units); ?>">
    </div>
<?php endif; ?>
<nav class="cocktail-controls" aria-label="<?php esc_attr_e('Cocktail controls', 'cocktail-recipes'); ?>">
    <div class="cocktail-control-row">
        <?php if ($servings_btns && $show_servings): ?>
            <div class="cocktail-control-group" role="group"
                aria-label="<?php esc_attr_e('Select servings', 'cocktail-recipes'); ?>">
                <span class="cocktail-control-label control-label-<?php echo esc_attr($label_type); ?>">
                    <?php esc_html_e('Servings', 'cocktail-recipes'); ?>
                </span>
                <div class="cocktail-btn-group">
                    <?php foreach ($servings_btns as $val): ?>
                        <button type="button"
                            class="cocktail-btn<?php echo $val == $servings ? ' selected' : ''; ?>"
                            <?php echo $val == $servings ? 'aria-pressed="true"' : 'aria-pressed="false"'; ?>
                            data-cocktail-action="servings"
                            data-value="<?php echo esc_attr($val); ?>">
                            <?php echo esc_html($val); ?>×
                        </button>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($unitList = $units_avail): ?>
            <div class="cocktail-control-group" role="group"
                aria-label="<?php esc_attr_e('Select units', 'cocktail-recipes'); ?>">
                <span class="cocktail-control-label control-label-<?php echo esc_attr($label_type); ?>">
                    <?php esc_html_e('Units', 'cocktail-recipes'); ?>
                </span>
                <div class="cocktail-btn-group">
                    <?php foreach ($unitList as $unit => $_): ?>
                        <button type="button"
                            class="cocktail-btn<?php echo $unit == $units ? ' selected' : ''; ?>"
                            <?php echo $unit == $units ? 'aria-pressed="true"' : 'aria-pressed="false"'; ?>
                            data-cocktail-action="units"
                            data-value="<?php echo esc_attr($unit); ?>">
                            <?php echo esc_html($unit_btns[$unit]); ?>
                        </button>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($show_view_btn): ?>
            <button type="button" class="cocktail-btn cocktail-toggle" data-cocktail-action="view"
                data-short-label="<?php echo esc_attr($view_short_btn); ?>"
                data-full-label="<?php echo esc_attr($view_full_btn); ?>">
                <?php echo esc_html($view_btn); ?>
            </button>
        <?php endif; ?>
    </div>
</nav>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
