<?php

if (!defined('ABSPATH')) exit;

/**
 * Partial Template: Cocktail Metadata
 *
 * Included via Output::render(); which limits variable scope to that method.
 */

use CocktailRecipes\Core\Helpers\Sanitizer;
use CocktailRecipes\Core\Helpers\Time;
use CocktailRecipes\Core\Helpers\User;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$showErrors = $errors && User::canEditPage() && $show_errors;
$showMetaData = $show_metadata && User::isAdmin();
if (!($showErrors || $showMetaData)) return;
$dataSource = $from_cache
    ? _x('cache', 'data source status', 'cocktail-recipes')
    : _x('rebuilt', 'data source status', 'cocktail-recipes');
?>
<div class="cocktail-admin-info">
    <?php if ($showErrors): ?>
        <div class="cocktail-errors">
            <strong><?php esc_html_e('Recipe Errors', 'cocktail-recipes'); ?>:</strong><br>
            <?php foreach ($errors as $error) echo esc_html(Sanitizer::stripEsc($error)) . '<br>'; ?>
        </div>
    <?php endif; ?>
    <?php if ($showMetaData): ?>
        <div class="cocktail-metadata">
            <?php echo esc_html_x('Time', 'metadata label', 'cocktail-recipes'); ?>:
                <?php echo esc_html(Time::formatElapsed($load_time, true)); ?>
            &bull; <?php echo esc_html_x('Source', 'metadata label', 'cocktail-recipes'); ?>:
                <?php echo esc_html($dataSource); ?>
            <?php if ($cache_age): ?>
                &bull; <?php echo esc_html_x('Age', 'metadata label', 'cocktail-recipes'); ?>:
                    <?php echo esc_html(Time::formatDuration($cache_age, 'compact')); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
