<?php

if (!defined('ABSPATH')) exit;

/**
 * Template: Cocktail Recipe
 *
 * Included via Output::render(); which limits variable scope to that method.
 */

use CocktailRecipes\Core\Helpers\HTML;
use CocktailRecipes\Core\Helpers\Output;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$opt = ' (' . _x('optional', 'optional ingredient suffix', 'cocktail-recipes') . ')';
?>
<div class="cocktail recipe-<?php echo esc_attr($view); ?>"
    <?php if ($card_link): ?>
    data-cocktail-action="link" data-card-link="<?php echo esc_attr(get_permalink()); ?>"
    <?php endif; ?>
    data-param-sfx="<?php echo esc_attr($param_sfx); ?>">
    <div class="cocktail-inner">
        <?php if ($ingredients): ?>
            <h4><?php esc_html_e('Ingredients', 'cocktail-recipes'); ?></h4>
            <ul class="ingredients">
                <?php foreach ($ingredients as $item): ?>
                    <li><?php echo wp_kses_post($item->toHtml()); ?><?php echo $item->optional ? esc_html($opt) : ''; ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <?php if ($summary): ?>
            <div class="cocktail-summary">
                <div class="cocktail-summary-inner">
                    <?php foreach ($summary as $label => $val): ?>
                        <div class="summary-item">
                            <b><?php echo esc_html($label) ?>:</b> <?php echo wp_kses_post($val->toHtml()); ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        <h4><?php esc_html_e('Instructions', 'cocktail-recipes'); ?></h4>
        <ol class="cocktail-details cocktail-instructions">
            <?php foreach ($instructions as $step): ?>
                <?php if (is_array($step)): ?>
                    <ul class="cocktail-instruction-notes">
                        <?php foreach ($step as $stepNote): ?>
                            <li><?php echo wp_kses_post($stepNote->toHtml()); ?></li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <li><?php echo wp_kses_post($step->toHtml()); ?></li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ol>
        <?php if ($notes): ?>
            <h4><?php esc_html_e('Notes', 'cocktail-recipes'); ?></h4>
            <ul class="cocktail-details cocktail-notes">
                <?php foreach ($notes as $note): ?>
                    <li><?php echo wp_kses_post($note->toHtml()); ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
    <?php
    // Output::partial() renders templates that escape all dynamic data internally
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    if ($show_controls) echo Output::partial('cocktail-controls', compact(
        'default_units',
        'default_view',
        'label_type',
        'servings',
        'servings_btns',
        'show_servings',
        'show_view_btn',
        'units',
        'unit_btns',
        'units_avail',
        'view_btn',
        'view_full_btn',
        'view_short_btn'
    ));
    ?>
    <?php if ($post_link): ?>
        <div class="cocktail-post-link cocktail-post-link-<?php echo esc_attr($post_link_pos); ?>">
            <a href="<?php echo esc_url(get_permalink()); ?>" class="cocktail-post-link-<?php echo esc_attr($post_link); ?>">
                <?php echo esc_html($post_link_text); ?>
            </a>
        </div>
    <?php endif; ?>
    <?php if ($sources): ?>
        <div class="cocktail-source">
            <?php if (count($sources) == 1): ?>
                <span class="cocktail-source-label"><?php esc_html_e('Source', 'cocktail-recipes'); ?>:</span>
                <span class="cocktail-source-item"><?php echo wp_kses_post($sources[0]->toHtml()); ?></span>
            <?php else: ?>
                <span class="cocktail-source-label"><?php esc_html_e('Sources', 'cocktail-recipes'); ?>:</span>
                <ul>
                    <?php foreach ($sources as $source): ?>
                        <li><?php echo wp_kses_post($source->toHtml()); ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php
    // Output::partial() renders templates that escape all dynamic data internally
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    if ($show_admin_info) echo Output::partial('cocktail-admin-info', compact(
        'cache_age',
        'errors',
        'from_cache',
        'load_time',
        'show_errors',
        'show_metadata'
    ));
    ?>
    <?php if ($show_attribution): ?>
        <div class="powered-by">
            <svg class="cocktail-recipes-icon" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg"
                fill="none" stroke="currentColor" stroke-width="6" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 12 H108" />
                <path d="M12 12 L60 70 L108 12" />
                <path stroke-width="4" d="M27 27 H93" />
                <path d="M60 70 V98" />
                <path d="M32 98 H88" />
                <path stroke-width="10" d="M62 46 L78 21" />
            </svg>
            <?php esc_html_e('Powered by', 'cocktail-recipes'); ?>
            <a href="https://www.isgdev.com/software/cocktail-recipes/"
                aria-label="<?php esc_attr_e('Learn more about Cocktail Recipes plugin', 'cocktail-recipes'); ?>"
                target="_blank" rel="noopener noreferrer">Cocktail Recipes</a>
        </div>
    <?php endif; ?>
</div>
<?php
if ($errors) echo '<!--' . esc_html(HTML::commentBlock('Recipe Errors', $errors, false)) . '-->';
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
